<?php
//******************************************************
// API key management API 
//
// http://localhost/ozeki/index.php?srv=aigate&api=apikey
//
//******************************************************

//******************************************************
// Load request
//******************************************************
header('Content-Type: application/json');

if (!isValidSignedInput($userid,$stationid,$req,$action,$error))
{
    ozerror(__FILE__,$error,$resp,$error);
    $resp=json_encode($resp);
    echo $resp;
    http_response_code(200);
    exit;
}

if (!isDecisionMaker($userid))
{
    ozerror(__FILE__,"Only admin users can create api keys. $userid is not listed as admin in admin.php in ozekiconfig.: $action",$resp,$error);
    $resp=json_encode($resp);
    echo $resp;
    exit;
}

//******************************************************
// Config
//******************************************************

date_default_timezone_set('UTC');

//******************************************************
// Return response
//******************************************************

switch ($action)
{
    case"createapikey":
        include_once("$dirprefix/ozekiservices/aigate/api/apikey/apikey_create.php");
        handlerequest_createapikey($userid,$req,$resp);
        break;
    case"deleteapikey":
        include_once("$dirprefix/ozekiservices/aigate/api/apikey/apikey_delete.php");
        handlerequest_deleteapikey($userid,$req,$resp);
        break;
    case"listapikeys":
        include_once("$dirprefix/ozekiservices/aigate/api/apikey/apikey_list.php");
        handlerequest_apikeylist($userid,$req,$resp);
        break;
    case"listcomments":
        include_once("$dirprefix/ozekiservices/aigate/api/apikey/apikey_listcomments.php");
        handlerequest_listcomments($userid,$req,$resp);
        break;
    case"updateapikey":
        include_once("$dirprefix/ozekiservices/aigate/api/apikey/apikey_update.php");
        handlerequest_updateapikey($userid,$req,$resp);
        break;
    default:
        ozerror(__FILE__,"Invalid fileserver action: $action",$resp,$error);
        break;
}

$resp=json_encode($resp);
echo $resp;

?>
