<?php
//***************************************************
// User list (for Admin)
//***************************************************
include_once("$sysdir/base/qualification.php");

$admindebug = false;
if (!isadmin()) return;

$sortby = "dateregistered";
//***************************************************
// Load user details
//***************************************************
function cmp($a, $b)
{
    global $sortby;
	if (!isset($a[$sortby])) return -1;
	if (!isset($b[$sortby])) return 1;
    if ($a[$sortby] == $b[$sortby]) {
        return 0;
    }
    return ($a[$sortby] > $b[$sortby]) ? -1 : 1;
}


function loadUsersForAdmin(&$userinfo,&$error)
{
	global $regdir,$myprivatekey,$adminuserid,$sortby;

	$userinfo = [];

	ozlsdir($regdir, $files, $users, $error);
	if ($users==null)
	{
		$error = "No registrations found";
		return false;
	}

	foreach($users as $user)
	{
		if ($user==$adminuserid) continue;
		$userdir = $regdir.'/'.$user;
		
		$aeskeyfile = $userdir.'/sharedto/'.$adminuserid.'_aesshared.txt';
		if (!file_exists($aeskeyfile)) 
			continue;

		$aeskeyencrypted = file_get_contents($aeskeyfile);
		if (!decryptTextRSA($myprivatekey,$aeskeyencrypted,$aeskey,$error))
			continue;
		
		if (!ozloadencryptedjson($aeskey,$userdir.'/registration.txt',$regdata,$error))
			continue;

		$regdata["userid"] = $user;
		
		if (loadpof($user,$p,$errorp))
			$regdata["p"] = $p;

		$userinfo[] = $regdata;
	}
	usort($userinfo,"cmp");
	return true;
}

function displayUser($x,$u)
{
	global $savepasswords;

	if (!is_array($u)) return;
	if (!isset($u["userid"])) return;

	$email = isset($u["email"])?$u["email"]:"";
	$fullname = isset($u["fullname"])?$u["fullname"]:"";
	$dateregistered = isset($u["dateregistered"])?$u["dateregistered"]:"";
	$p = isset($u["p"])?$u["p"]:"";

	$col = getUserQualificationColor($u["userid"]);
	echo "<tr style='background-color:$col'>";
	echo "<td>".$x."</td>";
	echo "<td>".$fullname."</td>";
	echo "<td>".$email."<br>".$u["userid"]."</td>";
	echo "<td>".$dateregistered."</td>";
	if (false && $savepasswords) //disabled
	{
		echo "<td class='text-end'>";
		echo displayLoginButton($email,$p);
		echo "</td>";
	}
	echo "<td class='text-end'>";
	echo displayOpenButton($u["userid"]);
	echo "</td>";
	echo "</tr>";
}

function displayOpenButton($userid)
{
	global $owpn;
$deleteButtonForm =<<<OPENBTN
	<a href='index.php?owpn=page_admin_datasheet&userid=$userid'>
     	<button class='btn btn-sm btn-success me-1'>Open</button>
	</a>
OPENBTN;
	return $deleteButtonForm;
}

//***************************************************
// Load user details
//***************************************************

loadUsersForAdmin($userinfo,$error);

//***************************************************
// Display user list
//***************************************************
echo card("Accounts");
echo "<span style='color:red;font-weight:bold'>$error</span>";

?>			
<div class="table-responsive scrollbar">
	<table class="table">
		<thead style="background-color: #eeeeee;">
			<tr>
				<th scope="col">No.</th>
				<th scope="col">Full name</th>
				<th scope="col">Email</th>
				<th scope="col">Creation date</th>
				<th class="text-end" scope="col">Open</th>
			</tr>
		</thead>
		<tbody>
		<?php 
			$x=0;
			foreach($userinfo as $u) {
				$x++;
				displayUser($x,$u);
			}
			echo getUserQualificationLegend();
		?>
		</tbody>
	</table>
</div>
<?
echo cardend();
?>
