<?php
include_once("$servicesdir/profile/common.profileimage.php");

function decryptProfileImages(&$error)
{
    global $regdir,$profile_image_encrypted;

    if ($profile_image_encrypted)
	{
		$error = "Profile image encryption is enabled. Decryption not possible.";
		return false;
	}

    if (!ozlsdir($regdir,$file,$dirs,$error)) return false;

    foreach($dirs as $userid)
    {
        $errord = "";
        if (!decrpytPorfileImageOfUser($userid,$errord))
        {
            $error .= "<b>Failed</b> ($userid): $errord<BR>";
        } else 
        {
            $error .= "<b>Success</b> ($userid): $errord<BR>";   
        }
    }
    return true;
}

function decrpytPorfileImageOfUser($userid,&$error)
{
    if (!ozloadaessharedkeyof($userid,$aeskey,$error)) 
    {
        $error = "Cannot load shared key of $userid. $error";
        return false;
    }
    if (!decryptProfileImage($userid,$aeskey,$error)) 
    {
        $error = "Cannot decrypt profile image of $userid. $error";
        return false;
    }
    $error = "";
    return true;
}

function displayProfileImages(&$ret,&$error)
{
    global $regdir;
    $ret = "";
    $error = "";

    if (!ozlsdir($regdir,$file,$dirs,$error)) return false;

    foreach($dirs as $userid)
    {
        $errord = "";
        if (!displayProfileImageOfUser($userid,$userimage,$errord))
        {
            $error .= "<b>Failed</b> ($userid): $errord<BR>";
        } else 
        {
            $ret .= "$userimage";   
        }
    }
    return true;
}

function displayProfileImageOfUser($userid,&$ret,&$error)
{
    $error = "";
    if (!ozloadaessharedkeyof($userid,$aeskey,$error)) 
    {
        $error = "Cannot load shared key of $userid. $error";
        return false;
    }
 
    $fullname = getName($userid);
    $profileImage = getProfileImage($fullname,$aeskey,$userid);
    $ret = "$fullname: $profileImage<hr>";
    return true;
}

//decryptProfileImages($result);
displayProfileImages($ret,$error);

echo card("Profile image list");
echo $ret;
echo $error;
echo cardend();
?>