<?php

$admindebug = false;
if ($userid==$adminuserid) return;

//***************************************************
// Support functions
//***************************************************

function removeRecursiveDirectory($path)
{
	$files = glob($path . '/*');
	foreach ($files as $file) {
		is_dir($file) ? removeRecursiveDirectory($file) : unlink($file);
	}
	rmdir($path);

	return;
}

//**************************************************************
// Delete user
//**************************************************************

if ($myaction == "deleteuser")
{
	$userid = $_POST["usertodel"];
	$userid = $userid;
	if ($userid==$adminuserid) return;

	$path = "$datadir/registrations/$userid";
	$salt = $delusersalt;
	$signature = $_POST["signature"];
	if (!importRsaPublicKeyFromPEM($adminpublickeypem, $publickey,$error))
	{
		$error = "Cannot import admin public key. $error";
		echo displayError("Failed",$error,"Go to user list",$page_admin_users);
        return;
	}

	if ($admindebug) {
		echo "<hr>";
		echo "<b>User id:</b> ".$userid."<BR>";
		echo "<b>Salt:</b> ".$delusersalt."<BR>";
		echo "<b>Signed text:</b> ".$userid.$delusersalt."<BR>";
		echo "<b>Signature:</b> ".$signature."<BR>";
		echo "<b>Public:</b> ".$mypublickey."<BR>";
	}

	if (isSignatureValid($userid.$delusersalt,$signature, $mypublickey, $error)) 
	{
		removeRecursiveDirectory($path);
		echo displaySuccess("Success", "User deleted successfully","Go to user list",$page_admin_users);
		return true;
	} else {
		$error = "Signature verification failed. $error";
		echo displayError("Failed",$error,"Go to user list",$page_admin_users);
        return true;
	}
}

addSessionData("delusersalt", ozrndstr());
if ($admindebug) echo "<b style='color:red'>Updating salt to: $delusersalt</b><BR>";

//**************************************************************
// Login button
//**************************************************************
function createUserDelCard($userid)
{
	global $myprivatekey,$owpn,$delusersalt;
	signRSA($myprivatekey, $userid.$delusersalt,$signature,$error);

$deleteButtonForm =<<<DELFORM
	<div>
	<form action='index.php' method='post' onsubmit="return confirm('Do you really want to delete this user?');">
	<input type='hidden' name='owpn' value='$owpn'>
	<input type=hidden name='myaction' value='deleteuser'>
	<input type='hidden' name='usertodel' value='$userid'>
	<input type='hidden' name='signature' value='$signature'>
	<button class='btn btn-danger me-1' type='submit'>Delete this user</button>
	</form>
	</div>
DELFORM;

$userbuttons =<<<USERBUTTONS
<div class="m-1">
	<div>
	<div class="float-start me-3">
	Warning!!! If you delete this user account all 
	associated data will be lost. The user will not be able to login again with 
	his username and password, and there will be no way to retrive his conversations, 
	settings and other data.
	</div>
	<div class="float-start mt-3">$deleteButtonForm</div>
	</div>
</div>
USERBUTTONS;

	$usercard = cardmin("User management");
	$usercard .= $userbuttons;
	$usercard .= cardminend();
	return $usercard;
}

//**************************************************************
// Regsiter card
//**************************************************************

$userinfocards["admin_deluser"]["display"] = "createUserDelCard";
return false;
?>
	