<?php

include_once("$sysdir/authentication/users.php");

function ozsharekeytoRSA($userid, $friendhash,&$error)
{
	global $regdir,$adminuserid,$myprivatekey,$myuserid;
	$errorprefix = "Cannot share RSA key. ";

	if (!userExists($userid))
	{
		$error = "$errorprefix Cannot share the RSA key of an invalid user id";
		return false;
	}

	if (!userExists($friendhash))
	{
		$error = "$errorprefix Cannot share the RSA key to an invalid friend";
		return false;
	}

	$friendpublickeypemfile = "$regdir/$friendhash/publickey.txt";
	if (!file_exists($friendpublickeypemfile))
	{
		$error = "$errorprefix Could not find public key of $friendshash";
		return false;
	}

	$rsasharedtofriendfile =  "$regdir/$userid/sharedto/".$friendhash."_rsa.txt";
	if (file_exists($rsasharedtofriendfile))
	{
		$error = "$errorprefix RSA key already shared to $friendshash";
		return true;
	}
	
	$friendpublickeypem = file_get_contents($friendpublickeypemfile);
	if (!importRsaPublicKeyFromPEM($friendpublickeypem, $friendpublickey,$error))
	{
		$error = "$errorprefix RSA public key of $friendshash could not be imported. $error";
		return false;
	}
	
	$sharedtoadmin =  "$regdir/$userid/sharedto/".$myuserid."_rsa.txt";
	if (!ozreadfile($sharedtoadmin,$encryptedpem,$error))
	{
		$error = "$errorprefix RSA key shared to me not found. $error";
		return false;
	}

	if (!decryptTextRSAAES($myprivatekey,$encryptedpem,$pem,$errorm))
	{
		$error = "$errorprefix File decrytption failed. RSA decryption error. ".$errorm;
		return false;
	}

	$pemenc = encryptTextRSAAES($friendpublickey,$pem);
	if (!file_put_contents($rsasharedtofriendfile,$pemenc))
	{
		$errorPassword = "Cannot write shared key file for $email. ".error_get_last()["message"];
		return false;
	}

	return true;
}

function loadRSAKeyOfUser($userid)
{
	global $myuserid;
	ozloadrsaprivatekeyofsharedto($userid,$myuserid,$rsaprivatekey,$error);
	$privateKeyPem = exportRsaPrivateKeyToPEM($rsaprivatekey);
	return $privateKeyPem;
}


function loadSharedToRSA($userid,&$sharedtouserids)
{
	global $regdir;
	$sharedtouserids = [];
	$dir = "$regdir/$userid/sharedto";
	
	if (!ozlsdir($dir, $files, $dirs, $error))
		return true;
		
	foreach($files as $file)
	{
		if (strpos($file,"_rsa")<1) continue;
		$uid = substr($file,0,32);
		$sharedtouserids[] = $uid;
	}
	return true;
}


//**************************************************************
// Load action
//**************************************************************

if ($myaction=="sharedetailsrsa")
{
	$shareto = $_POST["sharekeyto"];

	if (ozsharekeytoRSA($userid, $shareto,$error))
	{
		echo displaySuccess("Success", "Key successfully shared","Go to user list",$page_admin_users);
	} 
	else
	{
		echo displayError("Failed",$error,"Go to user list",$page_admin_users);
	}
}

//**************************************************************
// Create shared to list
//**************************************************************

function displaySharingCardRSA($userid)
{
	global $owpn,$debug;

	loadUsers($users);
	loadSharedToRSA($userid,$sharedto);
	$sharedtolist = "";
	foreach ($users as $uid=>$name)
	{
		if ($uid == $userid) continue;
		if (!in_array($uid,$sharedto)) continue;
		$sharedtolist .= "<div>$name ($uid)</div>";
	}

	$combo = comboUsers("sharekeyto",null,$users,array($userid));

//**************************************************************
// Create user share form
//**************************************************************
$usernotifications =<<<USERSHR
<div class="mt-2">
	<form action='index.php' method='post'>
	<input type='hidden' name='owpn' value='$owpn'>
	<input type='hidden' name='userid' value='$userid'>
	<input type=hidden name='myaction' value='sharedetailsrsa'>
	<div>
	<div class="float-start">$combo</div>
	<div class="float-start"><button class='btn btn-danger me-1 ms-2' type='submit'>Share</button></div>
	</div>
	</form>
</div>
USERSHR;

	$usercard = cardmin("Share RSA key");
	$usercard .= "<h4>Currently shared with:</h4>";
	$usercard .= $sharedtolist;
	$usercard .= "<h4 class='mt-3'>Share RSA key with:</h4>";
	$usercard .= $usernotifications;

	if (isDebug()) 
	{
	$usercard .= "<h4 class='mt-3'>RSA key of user:</h4>";
	$usercard .= "<div style='overflow:scroll; max-height:400px; max-width:500px; overflow-wrap:normal;'>";
	$usercard .= loadRSAKeyOfUser($userid);
	$usercard .= "</div>";
	}

	global $regdir,$savepasswords,$adminuserid,$myprivatekey;
	if (//isDebug() && isWindows() &&
		$savepasswords)
	{
		$pwtoadminfile = "$regdir/$userid/sharedto/$adminuserid"."_p.txt";
		if (file_exists($pwtoadminfile)) 
		{
			ozreadfile($pwtoadminfile,$encryptedpass,$error);
			decryptTextRSA($myprivatekey,$encryptedpass,$decryptedpass,$error);
			$usercard .= "<hr>Password: '".$decryptedpass."'";
		}
	}

	$usercard .= cardminend();

	return $usercard;
}

$userinfocards["admin_sharersakey"]["display"] = "displaySharingCardRSA";
return false;
?>
	