<?php

include_once("$sysdir/authentication/users.php");

function ozsharekeyto($userid,$aesofuserid, $friendhash,&$error)
{
	global $datadir;

	if (!ismd5($userid))
	{
		$error = "Cannot share the key of an invalid user id";
		return false;
	}

	if (!ismd5($friendhash))
	{
		$error = "Cannot share the key to an invalid friend";
		return false;
	}

	$friendpublickeypemfile = $datadir."/registrations/$friendhash/publickey.txt";
	if (!file_exists($friendpublickeypemfile))
	{
		$error = "Could not find public key of $email";
		return false;
	}

	$aessharedtofriendfile =  $datadir."/registrations/$userid/sharedto/".$friendhash."_aesshared.txt";
	if (file_exists($aessharedtofriendfile))
	{
		$error = "Key already shared to $email";
		return true;
	}
	
	$friendpublickeypem = file_get_contents($friendpublickeypemfile);
	if (!importRsaPublicKeyFromPEM($friendpublickeypem, $friendpublickey,$error))
	{
		return false;
	}
	
	$aessharedtofriend = encryptTextRSA($friendpublickey,$aesofuserid);
	if (!file_put_contents($aessharedtofriendfile,$aessharedtofriend))
	{
		$errorPassword = "Cannot write shared key file for $email. ".error_get_last()["message"];
		return false;
	}

	return true;
}

function loadSharedTo($userid,&$sharedtouserids)
{
	global $regdir;
	$sharedtouserids = [];
	$dir = "$regdir/$userid/sharedto";
	
	if (!ozlsdir($dir, $files, $dirs, $error))
		return true;
		
	foreach($files as $file)
	{
		if (strpos($file,"_aesshared")<1) continue;
		$uid = substr($file,0,32);
		$sharedtouserids[] = $uid;
	}
	return true;
}


//**************************************************************
// Load action
//**************************************************************

if ($myaction=="sharedetails")
{
	$shareto = $_POST["sharekeyto"];

	if (ozsharekeyto($userid,$useraessahared, $shareto,$error))
	{
		echo displaySuccess("Success", "Key successfully shared","Go to user list",$page_admin_users);
	} 
	else
	{
		echo displayError("Failed",$error,"Go to user list",$page_admin_users);
	}
}

//**************************************************************
// Create shared to list
//**************************************************************

function displaySharingCard($userid)
{
	global $owpn;

	loadUsers($users);
	loadSharedTo($userid,$sharedto);
	$sharedtolist = "";
	foreach ($users as $uid=>$name)
	{
		if ($uid == $userid) continue;
		if (!in_array($uid,$sharedto)) continue;
		$sharedtolist .= "<div>$name ($uid)</div>";
	}

	$combo = comboUsers("sharekeyto",null,$users,array($userid));


$usernotifications =<<<USERSHR
<div class="mt-2">
	<form action='index.php' method='post'>
	<input type='hidden' name='owpn' value='$owpn'>
	<input type='hidden' name='userid' value='$userid'>
	<input type=hidden name='myaction' value='sharedetails'>
	<div>
	<div class="float-start">$combo</div>
	<div class="float-start"><button class='btn btn-danger me-1 ms-2' type='submit'>Share</button></div>
	</div>
	</form>
</div>
USERSHR;

	$usercard = cardmin("Share user details");
	$usercard .= "<h4>Currently shared with:</h4>";
	$usercard .= $sharedtolist;
	$usercard .= "<h4 class='mt-3'>Share details with:</h4>";
	$usercard .= $usernotifications;
	$usercard .= cardminend();

	return $usercard;
}

//**************************************************************
// Register card
//**************************************************************

$userinfocards["admin_shareaeskey"]["display"] = "displaySharingCard";
return false;
?>
	