<?php
//**************************************************************
// Share RSA key of all users
//**************************************************************
global $sysdir;
include_once("$sysdir/encryption/encryption_user.php");
include_once("$sysdir/authentication/users.php");

//**************************************************************
// Support functions
//**************************************************************

function shareRSAKeysTo($sharedtoid,&$shared,&$notshared,&$error)
{
	global $regdir,$myprivatekey,$adminuserid,$sortby;

	$userinfo = [];

	ozlsdir($regdir, $files, $users, $error);
	if ($users==null)
	{
		$error = "No registrations found";
		return false;
	}

    $shared = [];
    $notshared = [];

	foreach($users as $userid)
	{
		if ($userid==$adminuserid) continue;
		if (shareUserAccess($userid,$sharedtoid,$error))
            $shared[] = $uesrid;
        else 
		    $notshared[] = $uesrid;
    }

    if (count($shared)>0) return true;
    return false;
}

function shareUserAccess($userid,$sharedtoid,&$error)
{
    if (!loadpof($userid,$p,$error)) 
    {
        echo "Cannot load password for $userid (".GetName($userid)."). $error<BR>";
        return false;
    }
    if (!ozsharersaprivatekeyto($userid,$p,$sharedtoid,$error)) 
    {
        echo "Cannot share key for $userid (".GetName($userid)."). $error<BR>";
        return false;
    }
    return true;
}

//**************************************************************
// Process data posted by test form
//**************************************************************
loadMyAction();

if ($myaction=='sharersa')
{
    loadReqParams("serviceemail");
    
    $serviceid = md5($serviceemail);
    if (!userExists($serviceid))
    {
        echo displayError("Sharing failed. User '$serviceemail' does not exist.", $error);
        return;
    }

    $ret = shareRSAKeysTo($serviceid,$shared,$notshared,$error);
    $msg = count($shared)." user keys shared and ";
    $msg .= count($notshared)." not shared";

    if ($ret)
    {
        echo displaySuccess("Sharing success", $msg);
        return;
    }
    else
    {
        echo displayError("Sharing failed", $error);
        return;
    }
}

//**************************************************************
// Display test form
//**************************************************************

if (isEmpty($serviceemail)) 
    $serviceemail="sales@ozeki.hu";

$frm =<<<NOTFRM
<div class="m-3" style="max-width:400px">
	<form action="index.php" method="post">
	<input type="hidden" name="owpn" value="$owpn">
    <input type="hidden" name="myaction" value="sharersa">
    <div class="row">
        <div>
        Service e-mail: <BR>
        <input type="text" class="form-control" name="serviceemail" value="$serviceemail">
        </div>
    </div>
    <div class="row">
        <div >
	        <button class="mt-2 btn btn-primary" name="random" type="submit">OK</button>
        </div>
    </div>
	</form>
</div>
NOTFRM;

echo card("Share access keys with");
echo $frm;
echo cardend();

?>