<?php
//***************************************************
// Setup default directories / Create config directory
//***************************************************
if (!is_dir($configdir) && !mkdir($configdir, 0777, true))
{
    echo "Could not create config directory; ".$path."; ".error_get_last()["message"];
    exit();
}

//***************************************************
// Setup default directories / Create config.php
//***************************************************
$configfile = $configdir."/config.php";

if (!is_file($configfile))
{
    if (isWindows())
    {
        $configtemplate = $sysdir."/setup/defaultconfigwindows.php";
        $configfilecontent = file_get_contents($configtemplate);
        $opensslloc = getOpenSSLConfigOnWindows();
        $configfilecontent = str_replace("[OPENSSLCONF]",$opensslloc,$configfilecontent);
        file_put_contents($configfile,$configfilecontent);
    }
    else 
    {
        $configtemplate = $sysdir."/setup/defaultconfig.php";
        copy($configtemplate, $configfile);
    }
}

//**********************************************************
// Setup default directories / Create configured directories
//**********************************************************

if (!is_dir($datadir) && !mkdir($datadir, 0777, true))
{
    echo "Could not create ozeki data directory; ".$path."; ".error_get_last()["message"];
	exit();
}

if (!is_dir($regdir) && !mkdir($regdir, 0777, true))
{
    echo "Could not create ozeki registration directory; ".$path."; ".error_get_last()["message"];
	exit();
}

if (!is_dir("$datadir/logs") && !mkdir("$datadir/logs", 0777, true))
{
    echo "Could not create ozeki log directory; $datadir/logs; ".error_get_last()["message"];
	exit();
}

if (!is_dir("$datadir/tmp") && !mkdir("$datadir/tmp", 0777, true))
{
    echo "Could not create ozeki tmp directory; $datadir/tmp; ".error_get_last()["message"];
	exit();
}

if (!is_dir("$datadir/sessions") && !mkdir("$datadir/sessions", 0777, true))
{
    echo "Could not create ozeki sessions directory; $datadir/sessions; ".error_get_last()["message"];
	exit();
}

if (!is_dir("$datadir/sessions/browser") && !mkdir("$datadir/sessions/browser", 0777, true))
{
    echo "Could not create ozeki sessions directory; /$datadir/sessionsbrowser"."; ".error_get_last()["message"];
	exit();
}

if (!is_dir("$datadir/sessions/ip") && !mkdir("$datadir/sessions/ip", 0777, true))
{
    echo "Could not create ozeki sessions directory; $datadir/sessions/ip"."; ".error_get_last()["message"];
	exit();
}

if (!is_dir("$dirprefix/ozekiservices") && !mkdir("$dirprefix/ozekiservices", 0777, true))
{
    echo "Could not create ozeki services directory; $dirprefix/ozekiservices; ".error_get_last()["message"];
	exit();
}

if (!is_dir("$datadir/services") && !mkdir("$datadir/services", 0777, true))
{
    echo "Could not create ozeki services data directory; $datadir/services; ".error_get_last()["message"];
	exit();
}

//**********************************************************
// Setup dirs config tempalte
//**********************************************************

$defaultdirsconfig = <<<DIRSEND
//***************************************************
// Directories
//***************************************************
//\$configdir = "$dirprefix\ozekiconfig";
//\$datadir = "$dirprefix\ozekidata";
DIRSEND;

file_put_contents("$configdir/dirs.php","<"."?php\r\n$defaultdirsconfig\r\n?".">");

?>