<?php
//***************************************************
// Create or load admin account details
//***************************************************
$adminconfig = $configdir."/admin.php";

//***************************************************
// Default user levels
//***************************************************
$adminstaff = [];
$developerstaff = [];
$staff = [];
$testuserstaff = [];
$testusers=[];

//***************************************************
// Setup admin account
//***************************************************
if (!is_file($adminconfig))
{
	include_once("$sysdir/setup/admininstall.php");
	if (!is_file($adminconfig)) 
	{
		printadminform();
		exit;
	}
}

//***************************************************
// Setup admin account
//***************************************************
include_once($adminconfig);
if (!isset($adminuser)) $adminuser = "admin@localhost";
if (!isset($adminuserid)) $adminuserid = md5($adminuser);

$admindir = $datadir."/registrations/$adminuserid";
if (!is_dir($admindir) && ($auth_provider=="basic"))
{
	include_once("$sysdir/setup/admininstall.php");
	printadminform();
	exit;
}

//***************************************************
// Setup password management
//***************************************************
if (isDebug()) $savepasswords = true;

//***************************************************
// Load admin key
//***************************************************
$pempublicfile = $datadir."/registrations/$adminuserid/publickey.txt";
$adminpublickeypem = file_get_contents($pempublicfile);
$adminpublickeyimported = importRsaPublicKeyFromPEM($adminpublickeypem,$adminpublickey,$error);

?>