<?php
//***************************************************
// install account details
//***************************************************
global $myaction;
loadReqParams("myaction");

if ($myaction=='setupadminpassword')
{
	$datavalid = true;

	//verify post data
	if (!isset($_POST["myadminemail"]))
	{
		$errorEmail = "Error: Cannot create admin account. Could not read admin e-mail address!";
        $datavalid = false;
	}

    //load form data
    if ($datavalid) {
        $email = trim($_POST["myadminemail"]);
        $password1 =  $_POST["mypassword1"];
        $password2 =  $_POST["mypassword2"];
        $userid = md5($email);
    }

	//input data verification
	if ($datavalid && !isemail2($email)) {
		$errorEmail = "Invalid e-mail address";
		$datavalid = false;
	} 

	
	if ($datavalid && $password1 != $password2) 
	{
		$errorPassword = "The two passwords do not match";
		$datavalid = false;
	} 

	if ($datavalid && !isPasswordTooShort($password1,$error)) 
	{
		$errorPassword = $error;
		$datavalid = false;
	} 

    $regdir = $datadir."/registrations";
    if ($datavalid && !ozmkdir($regdir,$error))
    {
        $errorEmail = "Error: Cannot create admin base directory!";
        $datavalid = false;
    }

	$userdir = $regdir."/".$userid;
    if ($datavalid && !ozmkdir($userdir,$error))
    {
        $errorEmail = "Error: Cannot create admin account directory!";
        $datavalid = false;
    }

	if ($datavalid && !generateRsaKeypair($privatekey,$publickey,$error))
	{
		$errorPassword = "Could not create RSA encryption keys. $error";
		$datavalid = false;
	}

    //create admin account
    if ($datavalid)
    {
        
		$aeskeyshared = generateAesKey();
		$aeskeyprivate = generateAesKey();
		$pwhash = sha512($password1);
		$pemprivate = exportRsaPrivateKeyToPEM($privatekey,$password1);
		$pempublic = exportRsaPublicKeyToPEM($publickey);

		date_default_timezone_set('UTC');
		$myreg = [];		
		$myreg["email"]=$email;
		$myreg["mobile"]= "";
		$myreg["fullname"]="Administrator";
		$myreg["country"]="Unknown";
		$myreg["dateregistered"]=date('Y-m-d H:i:s');
 		$myreg["datesuspended"]="";
		$myreg["dateterminated"]="";
		$myreg["regip"]=$_SERVER['REMOTE_ADDR'];;
		$myreg["issuspended"]=false;
		$myreg["isterminated"]=false;
		$myreg["reason"]="";
	
		//write customer files to user directory
		$pwdfile = $userdir."/pwd_".$pwhash.".txt";
		
		$pemprivatefile = $userdir."/privatekey_".$pwhash.".txt";
		if (!file_put_contents($pemprivatefile,$pemprivate))
		{
			$errorPassword = "Cannot write private key ".error_get_last()["message"];
			$datavalid = false;
		}
		
		$pempublicfile = $userdir."/publickey.txt";
		if ($datavalid && !file_put_contents($pempublicfile,$pempublic))
		{
			$errorPassword = "Cannot write public key ".error_get_last()["message"];
			$datavalid = false;
		}
		
		$aeskeysharedencrypted = encryptTextRSA($publickey, $aeskeyshared);
		$aessharedfile = $userdir."/aesshared.txt";
		if ($datavalid && !file_put_contents($aessharedfile,$aeskeysharedencrypted))
		{
			$errorPassword = "Cannot write aes shared key ".error_get_last()["message"];
			$datavalid = false;
		}
		
		$aeskeyprivateencrypted = encryptTextRSA($publickey, $aeskeyprivate);
		$aesprivatefile = $userdir."/aesprivate.txt";
		if ($datavalid && !file_put_contents($aesprivatefile,$aeskeyprivateencrypted))
		{
			$errorPassword = "Cannot write aes priate key ".error_get_last()["message"];
			$datavalid = false;
		}
		
		$myregjson = json_encode($myreg);
		$myregjsonencrypted = encryptTextAES($aeskeyshared, $myregjson);
		$regfile = $userdir."/registration.txt";
		if ($datavalid && !file_put_contents($regfile,$myregjsonencrypted))
		{
			$errorPassword = "Cannot write registration file ".error_get_last()["message"];
			$datavalid = false;
		}

		//Create admin config file
		$phpstart = '<'.'?php';
		$phpend = '?'.'>';
        $admindetails = <<<ADMINCONF
$phpstart
//Admin user
\$adminuser="$email";

//Decisionmakers
\$adminstaff[] = [];
//\$adminstaff[] = "d0eafbf473d60808db0a36d53b251b10";

//Developers
\$developerstaff[] = [];
//\$developerstaff[] = "d0eafbf473d60808db0a36d53b251b10";

//Employees
\$staff[] = [];
//\$staff[] = "d0eafbf473d60808db0a36d53b251b10";

//Test accounts
\$testuserstaff = [];
//\$testuserstaff[] = "694a34bddf1f47c91e9cc3e7daa96ae2"; //test1@ozeki.hu

//\$testusers[0]["email"] = "test1@ozeki.hu";
$phpend
ADMINCONF;


        if ($datavalid && !file_put_contents($adminconfig,$admindetails))
		{
			$errorPassword = "Cannot write admin configuration ".error_get_last()["message"];
			$datavalid = false;
		}

		//Add admin user e-mail to login session
		if ($datavalid)
		{
			addEncryptedSessionData("lastusername", $email);
			if ($debug) 
			{
				addEncryptedSessionData("lastpassword", $password1);
			}
		}
    }
}

//***************************************************
// Admin form
//***************************************************
function displayadminform()
{
	global $email,$password1,$password2,$errorEmail,$errorPassword;

	if (!isset($owpn)) $owpn="";
$adminform =<<<ADMINFORMEND
<div class="card justify-content-center align-middle mt-5" style="max-width: 400px; margin-left: auto; margin-right: auto;">
	<div class="card-header text-center">
        <img src="/ozekiservices/system/attachments/1/img/ozeki_logo_web_transparent.png" width="200px" class="mb-2"/>
		<h4>Setup the admin user</h4>
	</div>
	<div class="card-body bg-light">
		<form enctype="multipart/form-data" action="index.php" method="post" novalidate>
			<input type="hidden" name="owpn" value="page_dashboard">
			<input type="hidden" name="myaction" value="setupadminpassword">

			<div class="mb-3">
				<label class="form-label" for="toemail">Admin email</label>
				<input class="form-control" name="myadminemail" type="text" placeholder="admin@domain.com" value="$email" required/>
				<span style="color:red">$errorEmail</span>
			</div>
			
            <div class="row gx-2">
                  <div class="mb-3 col-sm-6">
                    <label class="form-label" for="card-password">Password</label>
                    <input class="form-control" type="password" name="mypassword1" autocomplete="on" id="card-password" value="$password1" />
                  </div>
                  <div class="mb-3 col-sm-6">
                    <label class="form-label" for="card-confirm-password">Confirm Password</label>
                    <input class="form-control" type="password" name="mypassword2" autocomplete="on" id="card-confirm-password" value="$password2" />
                  </div>
            </div>

            <div class="mb-3">
                <span class="form-label" for="card-email" style="color:red; font-weight:bold">$errorPassword</span>
            </div>

			<div class="mb-3 text-center">
				<button class="btn btn-primary" type="submit" name="messagecreate-submit">Create admin account</button>
			</div>
		</form>
	</div>
</div>
ADMINFORMEND;
    return $adminform;
} 

function printadminform()
{
	global $sysdir;
	include_once("$sysdir/base/layout.php");
	addsessiondata("browsermode","admin");
	echo printHtmlHeader();
	echo displayadminform();
	echo printHtmlFooter();
}

?>