<?php
//*****************************************
// Default variables
//*****************************************
$debugtime = false;
if (!isset($sessionsenabled)) $sessionsenabled = true;
if (!isset($myozekiroot)) {$myozekiroot = getcwd()."/..";}
$dirprefix = realpath($myozekiroot);

//******************************************************
// Environment
//******************************************************
include_once("$dirprefix/ozeki/sys/base/flags.php");

//*****************************************
// Error reporting
//*****************************************
if (isDebug() || isWindows())
{
    error_reporting(E_ALL);
} 
else if (isWindows())
{
    error_reporting(E_ALL & ~E_NOTICE);
} 
else 
{
    error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
}

//*****************************************
// Random number generator
//*****************************************
list($usec, $sec) = explode(' ', microtime());
$seed = $sec + $usec * 1000000;
srand($seed);

//*****************************************
// Load base libraries
//*****************************************
include_once("$dirprefix/ozeki/sys/base/base.php");

//*****************************************
// Setup directories
//*****************************************
include_once("$dirprefix/ozeki/sys/setup/dirs.php");

//*****************************************
// Protect against hackers and bots
//*****************************************
include_once("$dirprefix/ozeki/sys/setup/protect.php");

//*****************************************
// Create default directory structure
//*****************************************
if (!is_dir($configdir) || !is_dir($datadir))
{
    include_once("$sysdir/setup/defaultdirs.php");
}

//*****************************************
// Default config
//*****************************************
$sitetitle = "Ozeki Web Services";
$siteemail = "admin@localhost";
$siteid = "VsLO7jLJLU1SmDvQxJoAfCeDAPBPJp8ry5UMZ09hdr4=";
$siteurl = "http://localhost/ozeki";
$siteprefix = "/ozeki/";
$usehttps = false;
$forcehttp = false;
$debug = false;
$debuglogin = false;
$debugtime = false;
$debugredirects=false;
$debuglog = "";
$auth_allowregistration = true;
$timezone = "Europe/Budapest";

//*****************************************
// Load config
//*****************************************
$configfile = "$configdir/config.php";
if (file_exists($configfile)) include_once($configfile);

//*****************************************
// Time
//*****************************************
if (!isset($timezone)) $timezone = "Europe/Budapest";
date_default_timezone_set($timezone);

if ($debugtime)
{
    include_once("$sysdir/base/debugtime.php");
    prof_flag("Start");
}

//*****************************************
// Load versions
//*****************************************
$configuredversions = $configdir."/versions.php";

if (is_file($configuredversions))
{
    include_once($configuredversions);
}

//*****************************************
// Load service pagenumber allocations
//*****************************************
include_once("$dirprefix/ozeki/pagenumbers.php");

if ($debugtime) prof_flag("Service page numbers loaded");

//******************************************************
// Identify page intent
//******************************************************

$srv = (isset($_REQUEST["srv"])) ?  $_REQUEST["srv"] : "";
$api = (isset($_REQUEST["api"])) ?  $_REQUEST["api"] : "";
$owpn = (isset($_REQUEST["owpn"])) ?  $_REQUEST["owpn"] : "";

//*****************************************
// Load configured apis
//*****************************************
include_once("$sysdir/base/api.php");

$apisfile = $configdir."/apis.php";
if (is_file($apisfile))
{
    include_once($apisfile);    
}

if ($debugtime) prof_flag("APIs loaded");

//*****************************************
// Load the Dashboard
//*****************************************
include_once("$dirprefix/ozekiservices/dashboard/_include.php");

//*****************************************
// Setup page number
//*****************************************
if ($api!="")
{
    if (isset($pagealias) && is_array($pagealias) && (array_key_exists($api,$pagealias))) 
    {
        ob_end_clean();
        if (!isset($outputbuffering) || $outputbuffering==true) ob_start();
        $owpn=$pagealias[$api];
    } 
    else
    {
        echo "API not found.<BR>\r\n";
        echo "Srv: $srv<BR>\r\n";
        echo "Api: $api<BR>\r\n";
        return;
    }
}

function determineFirstPage()
{
    if (isBrowserCef()) return "page_chat_home";
    return "page_dashboard";
}

if (!isset($owpn) && isset($_REQUEST["owpn"])) $owpn = $_REQUEST["owpn"];
if (!isset($owpn)) $owpn=determineFirstPage();
if ($owpn=="") $owpn=determineFirstPage();
if ($owpn=="page_dashboard") $owpn=$page_dashboard;

//*****************************************
// Load system libraries
//*****************************************
include_once("$sysdir/base/sessions.php");
include_once("$sysdir/encryption/encryption.php");
include_once("$sysdir/encryption/encryption_user.php");
include_once("$sysdir/setup/adminsetup.php");
include_once("$sysdir/base/flags.php");
include_once("$sysdir/base/layout.php");
include_once("$sysdir/form/repost/repost.php");
include_once("$sysdir/authentication/_include.php");
include_once("$sysdir/footerbar/common.php");

//*****************************************
// Load system service
//*****************************************
include_once("$dirprefix/ozekiservices/system/_include.php");
include_once("$dirprefix/ozekiservices/system/_api.php");

if ($debugtime) prof_flag("System loaded");

//*****************************************
// It mainsite return
//*****************************************
if (isset($mainsite) && $mainsite==true) return;

//*****************************************
// Setup page number after authentication
//*****************************************

if (isset($myuserid) && userexists($myuserid)) 
{
	if ($owpn=="page_authentication_login") $owpn=determineFirstPage();
	if ($owpn=="page_authentication_registration")
	{
    		delSessionData("lastusername");
    		delSessionData("lastpassword");
    		logoutFromSession();
	}
}

//*****************************************
// No more job if an API service is called
//*****************************************
if (isapi()) return;

//*****************************************
// Go to http
//*****************************************

if (!isWindows() && isset($forcehttp) && $forcehttp && $_SERVER["REQUEST_METHOD"]=="GET" && isHttps() && !isOzeki10())
{
    if (!isset($_SERVER["SERVER_PORT"])) 
    {
        $port = "";
    }
    else
    {
        $port = ($_SERVER["SERVER_PORT"]!=443) ? ":".$_SERVER["SERVER_PORT"] : "";
    }
    $url = "http://".$_SERVER['SERVER_NAME'].$port.$_SERVER['REQUEST_URI'];
    $location = $url;
    global $debugredirects;
    if ($debugredirects)
    {
      echo "Redirect after protocol change:<BR>";
      echo "<a href='$location'>$location</a>";
      exit;
    }

    $redirecturl = $url;
    error_log("sys/setup/_include 242:  Redirecting browser to $redirecturl. Original request: ".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI']);
    header("X-Ozeki-Redirect: sys setup 243");
    header("Location: $redirecturl");
    exit;
}

//*****************************************
// Go to https
//*****************************************

if (!isWindows() && isset($usehttps) && $usehttps && $_SERVER["REQUEST_METHOD"]=="GET" && !isHttps() && !isOzeki10() && (!isset($forcehttp) || !$forcehttp))
{
    if (!isset($_SERVER["SERVER_PORT"]))
    {
        $port = "";
    }
    else
    {
        $port = ($_SERVER["SERVER_PORT"]!=80) ? ":".$_SERVER["SERVER_PORT"] : "";
    }
    $url = "https://".$_SERVER['SERVER_NAME'].$port.$_SERVER['REQUEST_URI'];
    $location = $url;
    global $debugredirects;
    if ($debugredirects)
    {
      echo "Redirect after protocol change:<BR>";
      echo "<a href='$location'>$location</a>";
      exit;
    }

    $redirecturl = $url;
    error_log("sys/setup/_include 273:  Redirecting browser to $redirecturl. Original request: ".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI']);
    header("X-Ozeki-Redirect: sys setup 274");
    header("Location: $redirecturl");
    exit;
}

//*****************************************
// Load the service Installer
//*****************************************
include_once("$dirprefix/ozekiservices/subscriptions/_include.php");

//*****************************************
// Load configured services
//*****************************************
$servicesfile = $configdir."/services.php";
if (!is_file($servicesfile))
{
    $servicestemplate = $sysdir."/setup/defaultservices.php";
    copy($servicestemplate, $servicesfile);
}
include_once($servicesfile);

if ($debugtime) prof_flag("Global services loaded");

//*****************************************
// Load user services
//*****************************************

if (isset($myuserid) && !isEmpty($myuserid)) 
{
   $userservices = $datadir."/registrations/".$myuserid."/subscriptions/subscriptions.txt";
   if (file_exists($userservices)) 
   {
        $slist = file_get_contents($userservices);
        preg_match_all('/include_once.["\']([^"\']*)["\']/',$slist,$matches);
        $flist = $matches[1]; 
        foreach ($flist as $filetoinclude)
        {
            $f = str_replace('$servicesdir',$servicesdir,$filetoinclude);
            if (file_exists($f)) include_once($f);
        }
   }
}

if ($debugtime) prof_flag("User services loaded");

//*****************************************
// Finalize the page number
//*****************************************

if (ozstartswith($owpn,"page_"))
{
    if (isset($owpn)) {
        $owpname = $owpn;
        if (isset($$owpn)) {
            $owpnumber = $$owpn;
            $owpn = $$owpn;
        } 
        else
        {
            $owpnumber = "";
            $owpn = "";
        }
    } 
    else 
    {
        $owpname = "";
        $owpnumber = "";
        $owpn = "";
    }

    if (isEmpty($owpn))
    {
        $logouturl = "index.php?owpn=page_authentication_logout&justloggedout=true";
        $dashboardurl = "index.php?owpn=page_dashboard";
        if ($debug) {
            echo "Could not find page $owpname. <BR>"; 
            echo "<div style='margin: 20px 0px 0px 0px'><a href='$logouturl'>Click here to <b>Login</b></a></div>";
            echo "<div style='margin: 20px 0px 0px 0px'><a href='$dashboardurl' class='btn btn-primary'>Click here to go to <b>Dashboard</b></a></div>";
            exit;
        } else
        {
            $redirecturl = $logouturl;
            error_log("sys/setup/_include 280:  Redirecting browser to $redirecturl. Original request: ".$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI']);
            header("X-Ozeki-Redirect: sys setup 280");
            header("Location: $redirecturl");
            exit;
        }
    }
} 
else
{
    $owpnumber = $owpn;
    $owpname = $pagelink[$owpn]; 
}

$owptitle = $pagename[$owpnumber];
$owpservice = $pageservice[$owpn];

//echo "Final pagenumber: $owpnumber; title: $owptitle; service; $owpservice; loggedin: $loggedin"; exit;

//*****************************************
// Log the visit
//*****************************************
$logcollectfile = "$dirprefix/ozekiservices/visitorlog/logcollect/logcollect.php";
if (file_exists($logcollectfile)) 
{
    include_once($logcollectfile);
}

?>
