<?php
//******************************************************
// I. Service roles
// 1.) Customer (creates requests)
// 2.) Employee (works with the consolse)
// 3.) Admin (creates console access)
//******************************************************

include_once("$sysdir/authentication/registrationcreateuser.php");
include_once("$sysdir/authentication/users.php");
include_once("$sysdir/encryption/encryption_rsa.php");

//******************************************************
// II. Add console access (support/sales/etc) for employees.
//
// $source "servicename/filename" //logoláshoz hozzuk létre, hogy tudjuk honnan jött a hívás
// $servicename = "sales" //ebből származik: "salesconsole","salesadmin"
// $employeeid = md5("employee@ozeki.hu"); //$regdir/$employeeid-ra mutat; Ez az employee kap console hozzáférést
//
// $servicetitle = "Ozeki Sales"; //A szolgáltatás account neve
// $serviceid = md5("sales@ozeki.hu"); //A szolgáltatás account címe (md5 hash; $regdir/md5)
// $servicepassword = "234sdf23"; //A sales@ozeki.hu jelszava
//******************************************************

function updateUserService($createinfo,&$error)
{
    $json = json_encode($createinfo);
 
    global $regdir;
    $serviceid = $createinfo["serviceid"];
    if (!ismd5($serviceid))
    {
        $error = "Invalid service id";
        return false;
    }
    $path = "$regdir/$serviceid/details.txt";
    if(!ozsavefile($path,$json,$errorm))
    {
        $error="Cannot update service. Cannot write details.";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }
    return true;
}

function loadUserService($serviceid,&$createinfo,&$error)
{
    global $regdir;
    if (!ismd5($serviceid))
    {
        $error = "Invalid service id";
        return false;
    }
    $path = "$regdir/$serviceid/details.txt";
    if (!file_exists($path))
    {
        $error = "Service information not found";
        return false;
    }
    
    return ozreadjson($path,$createinfo,$error);
}


function addUserService($source,$servicename, $servicetitle,$serviceemail,$servicepassword,&$createinfo,&$error)
{
    global $regdir,$myuserid,$debug;

    //Input data validation
    $servicename = trim($servicename);
    $serviceemail = trim($serviceemail);
    $servicepassword = trim($servicepassword);
    $servicephone = "+111111111111";

    if (isempty($servicename))
    {
        $error = "Cannot create service. The service name cannot be empty.";
        return false;
    }

    if (isempty($servicetitle))
    {
        $error = "Cannot create service. The service title cannot be empty.";
        return false;
    }

    if (isempty($serviceemail) || !isemail($serviceemail))
    {
        $error = "Cannot create service. The service email cannot be empty. It must be a valid e-mail address.";
        return false;
    }

    if (!isPasswordTooShort($servicepassword,$error))
    {
        $error = "Cannot create service. The supplied password is not valid. $error";
        return false;
    }

    $serviceid = md5($serviceemail);

    if (userExists($serviceid))
    { 
        if (!ozsharersaprivatekeyto($serviceid,$servicepassword,$myuserid,$errorm))
        {
            $error = "Invalid service password. Cannot subscribe to $servicename.";
            if ($debug) { $error.= " ".$errorm;}
            return false;
        }

        if(!saveUserServiceDetailsForMe($servicename, $serviceid, $servicetitle, $errorm))
        {
            $error = "Cannot create service. Could not save service details for me.";
            if ($debug) { $error.= " ".$errorm;}
            return false;
        }
        return true;
    }
    
    //Create user account for service
    if (!createUser($serviceid, $serviceemail, $servicetitle, $servicepassword,$out_privatekey,$out_error, $servicephone))
    {
        $error = "Cannot create service. The service creation failed. $out_error";
        return false;
    }

    //Create information
    $createinfo["serviceid"] = $serviceid;
    $createinfo["title"] = trim($servicetitle);
    $createinfo["createdby"] = $myuserid;
    $createinfo["type"] = "service";
    $createinfo["servicename"] = $servicename;
    $createinfo["createdate"] = mysqldate();
 
    $path = "$regdir/$serviceid/details.txt";
    if(!updateUserService($createinfo,$errorm))
    {
        $error="Cannot create service. Cannot write details.";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }

    if (!ozfileaddtolist("$regdir/$myuserid/serviceowner.txt",$serviceid,$errorm))
    {
        $error = "Cannot create service. Cannwot create oganization serviceowner record.";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }

    //Create information for admin staff
    global $datadir;
    $sd = "$datadir/services/$servicename/admins/$myuserid/$serviceid";
    if (!ozmkdir($sd,$errorm))
    {
        $error="Cannot create service. Cannot setup owner access. $errorm";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }

    $sf = "$sd/details.txt";
    if (!ozsavejson($sf,$createinfo,$errorm))
    {
        $error="Cannot create service. Cannot install owner access. $errorm";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }

    //Share RSA key with creator
    if (!ozsharersaprivatekeyto($serviceid,$servicepassword,$myuserid,$errorm))
    {
        $error="Cannot create service. Cannot save RSA key. $errorm";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }

    //Share RSA key with admins
    global $adminstaff;
    if (is_array($adminstaff))
    {
        foreach($adminstaff as $adminuserid)
        {
            if (!ismd5($adminuserid)) continue;
            ozsharersaprivatekeyto($serviceid,$servicepassword,$adminuserid,$errorm);
        }
    }

    //Save user service details with creator
    if(!saveUserServiceDetailsForMe($servicename, $serviceid, $servicetitle, $errorm))
    {
        $error = "Cannot create service. Could not save service details for me.";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }

    //Log
    $log = "Service created ($source): $servicename, $serviceid";
    ozlog(__FILE__, "INFO", $log);

    return true;
}

function saveUserServiceDetailsForMe($servicename, $serviceid, $servicetitle)
{
    global $regdir, $myuserid;
    //create console for employee
    $newService["title"]=$servicetitle;
    $newService["serviceid"]=$serviceid;
    $json = json_encode($newService);

    if (!ismd5($serviceid))
    {
        $error = "Cannot setup user service subscription. Invalid service id.";
        return false;
    }

    $dir = "$regdir/$myuserid/$servicename"."admin/$serviceid";
    if (file_exists($dir) && !is_dir($dir))
    {
        unlink($dir);
    }

    if(!ozmkdir($dir, $errorm))
    {
        $error = "Cannot setup user service subscription. Could not create directory for storing $servicename employees. $errorm";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }

    $servicesfile = "$dir/details.txt";
    if (file_exists($servicesfile)) return true;
    if (!ozsavefile($servicesfile,$json,$errorm))
    {
        $error = "Cannot setup user service subscription. Could not save service for me.";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }
     
    return true;
}

function loadSelectedServiceDetails(&$serviceid,&$createinfo,&$error)
{
    if (isEmpty($serviceid))
    {
	    global $serviceid;
    }

	if (isEmpty($serviceid)) 
	{
		loadReqParams("serviceid");
	}
	
	if (!ismd5($serviceid))
	{
		$error = "Could not load service details. Invalid service id.";
		return false;
	}

	if (!loadUserService($serviceid,$createinfo,$error))
	{
		$error = "Could not load recruitment service details. $error";
		return false;
	}

	return true;
}

//***************************************************
// Service loaded
//***************************************************

function serviceIDLoaded($page_home)
{
	global $serviceid;
	if (isEmpty($serviceid))
	{
		loadReqParams("serviceid");
	}

	if (!isEmpty($serviceid)) return true;
	echo displayError("Could not load service",
    "Please select the service from home","Go to home","$page_home");
	return false;
}


?>
