<?php
global $sysdir;
include_once("$sysdir/services/console.php");


//*****************************************************************
// Customers
//*****************************************************************

function printCustomerList($servicename, $displayFunc="printServiceCustomerDetails")
{
    global $dirprefix,$owpn,$myaction,$serviceid,$customerid,$consoleid;

    $ucservicename = ucfirst($servicename);

    //************************************************************
    // Delete customer subscription
    //************************************************************
    if ($myaction=='delcustomer')
    {
        include_once("$dirprefix/ozekiservices/ticket/common/common.subscribe.php");
        $source = "ticketadmin/consoles/consolelist.php";

        loadReqParams("serviceid","customerid");
        $reason = "Admin delete request";

        $ret = ticket_unsubscribeSupportService($source,$serviceid,$customerid,$reason,$error);

        if ($ret)
        {
            echo displaySuccess("Success", "$ucservicename customer unsubscribed successfully");
            return;
        } 
        else
        {
            echo displayError("Customer unsubscribe failed",$error);
            return;
        }
    }

    //************************************************************
    // Display
    //************************************************************

    //$addBtn="<a class='btn btn-success' href=index.php?owpn=$owpn&action=consoleadd>Add...</a>";
    $ret = card(ucfirst($servicename)." admin: Customer list");
    $ret .= printAllUserServiceCustomers($servicename, $displayFunc);
    $ret .= cardend(); 

    return $ret;
}

function printAllUserServiceCustomers($servicename, $displayFunc)
{
    if (!loadConsoleAdminDetails($servicename,$services,$error)) 
    {
        return displayError("Display error","Cannot load console information. ".$error);
    }

    $servicenameuc = ucfirst($servicename);

    $returnHTML="";
    if(isEmpty($services))
    {
        $setuphelp =<<<SETUPHELP
<H4>Please setup your service</H4>
<p>
You can setup your $servicenameuc service by clicking on "Add service" in the navbar. Once your 
service has been setup you will be able to add subordinates, who help you provide this service.
Subordinates will be able to work with people interested in your service. As the service administrator
your job will be to create and manage subordinate accounts.
</p>

SETUPHELP;
        return $setuphelp;
    }

    foreach($services as $service)
    {
        $serviceHTML=printUserServiceCustomers($servicename, $service,  $displayFunc);
        $returnHTML .= $serviceHTML;
    }
    return $returnHTML;
}

function printUserServiceCustomers($servicename, $service,  $displayFunc)
{
    global $owpn;
    $serviceTitle=$service["title"];
    $serviceid=$service["serviceid"];
    $serviceCustomers = printUserServiceCustomerList($servicename, $service, $displayFunc);

    $returnHTML=<<<SERVICEHTML
    <div class="row mt-2">
        <div class="col">
            <div style="font-size:120%;font-weight: bold;">
            $serviceTitle ($serviceid)
            </div>
            <div style="font-size:80%;">
            <b style="color:#303060">Customers</b>
            $serviceCustomers
            </div>
        </div>
    </div>
SERVICEHTML;
return $returnHTML;
}


function printUserServiceCustomerList($servicename, $service,$displayFunc)
{
    global $owpn;
    $serviceid=$service["serviceid"];
    $list = "<ol>";
    foreach($service["customers"] as $customerid=>$customername)
    {
        $url = "index.php?owpn=$owpn&myaction=delcustomer&serviceid=$serviceid&customerid=$customerid&servicename=$servicename";
        $dellink = "<a href='$url' onclick='return confirm(\"Are you sure you wish to delete this customer?\");'>[Del]</a>";

        /*if (!loadAesKeyForService("ticket",$customerid,$serviceid,$aeskeyofcustomer,$error))
        {
            $aeskeyofcustomer = "<span style='color:red'>$error</span>";
        }*/

        $details = $displayFunc($serviceid,$customerid,$customername,$dellink);
        $list .= "<li>".$details."</li>";
    }
    $list .= "</ol>";
    return $list;
}


function printServiceCustomerDetails($serviceid,$customerid,$customername,$dellink)
{
    return "$customername ($customerid) $dellink";
}

?>