<?php
//******************************************************
// I. Service roles
// 1.) Customer (creates requests)
// 2.) Employee (works with the console)
// 3.) Admin (creates console access)
//******************************************************

include_once("$sysdir/authentication/users.php");
include_once("$sysdir/services/service.php");

//******************************************************
// II. Add console access (support/sales/etc) for employees.
//
// $source "servicename/filename" //logoláshoz hozzuk létre, hogy tudjuk honnan jött a hívás
// $servicename = "sales" //ebből származik: "salesconsole","salesadmin"
// $employeeid = md5("employee@ozeki.hu"); //$regdir/$employeeid-ra mutat; Ez az employee kap console hozzáférést
//
// $servicetitle = "Ozeki Sales"; //A szolgáltatás account neve
// $serviceid = md5("sales@ozeki.hu"); //A szolgáltatás account címe (md5 hash; $regdir/md5)
// $servicepassword = "234sdf23"; //A sales@ozeki.hu jelszava
//******************************************************

function addConsole($source,$servicename,$employeeid,$servicetitle,$serviceid,$servicepassword,&$error)
{
    global $regdir,$myuserid,$debug;

    if (!userExists($serviceid))
    {
        $error = "Cannot install console. The $servicename service was not found.";
        return false;
    }

    if (!userExists($employeeid))
    {
        $error = "Cannot install console. The $servicename employeeid was not found.";
        return false;
    }

    $employeeservicespath = "$regdir/$employeeid/$servicename"."console";
    if(!ozmkdir("$employeeservicespath", $errorm))
    {
        $error = "Cannot install console. The console directory could not be created.";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }

    $consolefile = "$employeeservicespath/$serviceid";
    if(file_exists($consolefile))
    {
        $error="Cannot install console. The $servicename console is already configured for this user.";
        if ($debug) { $error.= " ".$consolefile;}
        return false;
    }

    $privatekeyofservice = "$regdir/$serviceid/privatekey_".sha512($servicepassword).".txt";
    if (!file_exists($privatekeyofservice))
    {
        $error="Cannot install console. Invalid service password.";
        if ($debug) { $error.= " ".$privatekeyofservice;}
        return false;
    }

    $pem = file_get_contents($privatekeyofservice);
	if (!importRsaPrivateKeyFromPEM($pem, $servicepassword, $privateKey, $publicKey, $errorm))
    {
        $error="Cannot install console. Cannot load service private key.";
        if ($debug) { $error.= " ".$errorm;}
		return false;
    }

    //share private key of service to employee
    $pem  = exportRsaPrivateKeyToPEM($privateKey);

    if (!ozencryptrsaaesto($employeeid,$pem,$pemencrypted,$errorm))
    {
        $error="Cannot install console. Cannot save service information for employee.";
        if ($debug) { $error.= " ".$errorm;}
		return false;
    }

    //echo "Encrypting pem:".$pem."<br>:Encrpyted: $pemencrypted"."<br>";

    $sharedrsakeyfile = "$regdir/$serviceid/sharedto/$employeeid"."_rsa.txt";
    if (!ozsavefile($sharedrsakeyfile,$pemencrypted,$errorm))
    {
        $error="Cannot install console. Cannot save shared key of service for employee.";
        if ($debug) { $error.= " ".$errorm;}
		return false;
    }

    //Make the access key of the service public for notifications
    if (!makeAccessKeyPublic($serviceid,$privateKey,$errorm))
    {
        $error = "Cannot install console. Cannot make the access key of the $servicename service public to send notifications.";
        if ($debug) { $error.= " ".$errorm;}
		return false;
    }

    //create console for employee
    $newService["title"]=$servicetitle;
    $newService["serviceid"]=$serviceid;
    $newService["enabled"]=1;
    $json = json_encode($newService);
 
    $employeeservicesdir = "$regdir/$employeeid/$servicename"."console/$serviceid";
    if (file_exists($employeeservicesdir) && !is_dir($employeeservicesdir))
    {
        unlink($employeeservicesdir);
    }

    if(!ozmkdir($employeeservicesdir, $errorm))
    {
        $error="Cannot install console. Error while creating console dir for employee.";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }

    $employeeservicesfile = "$regdir/$employeeid/$servicename"."console/$serviceid/details.json";
    if(!ozsavefile($employeeservicesfile,$json,$errorm))
    {
        $error="Cannot install console. Error while saving services.";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }

    //Register employee for service
    $dirsrv = "$regdir/$serviceid/".$servicename."admin";
    if(!ozmkdir($dirsrv, $errorm))
    {
        $error = "Cannot install console. Could not create service directory for storing $servicename employees.";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }

    $usersfile = "$dirsrv/consoleusers.txt";
    if (!ozfileaddtolist($usersfile,$employeeid,$errorm))
    {
        $error = "Cannot install console. Could not add employee to $servicename console user list.";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }

    //Register service for me (service admin)
    if (!saveUserServiceDetailsForMe($servicename, $serviceid, $servicetitle, $errorm))
    {
        $error = "Cannot install console. Could not save service details for me.";
        if ($debug) { $error.= " ".$errorm;}
        return false;
    }

    //Share service key to me (service admin)
    if (!ozencryptrsaaesto($myuserid,$pem,$pemencrypted,$errorm))
    {
        $error="Cannot install console. Cannot save service information for employee.";
        if ($debug) { $error.= " ".$errorm;}
		return false;
    }

    $sharedrsakeyfile = "$regdir/$serviceid/sharedto/$myuserid"."_rsa.txt";
    if (!ozsavefile($sharedrsakeyfile,$pemencrypted,$errorm))
    {
        $error="Cannot install console. Cannot save shared key of service for employee.";
        if ($debug) { $error.= " ".$errorm;}
		return false;
    }
    
    //Share service key to admin 
    global $adminuser;
    $adminuserid = md5($adminuser);
    if (!ozencryptrsaaesto($adminuserid,$pem,$pemencrypted,$errorm))
    {
        $error="Cannot install console. Cannot save service information for admin.";
        if ($debug) { $error.= " ".$errorm;}
		return false;
    }

    $sharedrsakeyfile = "$regdir/$serviceid/sharedto/$adminuserid"."_rsa.txt";
    if (!ozsavefile($sharedrsakeyfile,$pemencrypted,$errorm))
    {
        $error="Cannot install console. Cannot save shared key of service for admin.";
        if ($debug) { $error.= " ".$errorm;}
		return false;
    }

    //Install console app for employee
    global $dirprefix;
    include_once("$dirprefix/ozekiservices/subscriptions/common.php");
    if (!subscribeService($employeeid,$servicename."console",$errorm))
    {
        $error="Cannot install $servicename console for employee $employeeid. App installation error.";
        if ($debug) { $error.= " ".$errorm;}
		return false;
    }

    //Log
    $log = "Console access created ($source): $serviceid, $employeeid,";
    ozlog(__FILE__, "INFO", $log);

    return true;
}

//******************************************
// Delete consolse access
//******************************************
function delConsole($source,$servicename,$serviceid,$employeeid,$reason, &$error)
{
    global $regdir;
    $myservicespath = "$regdir/$employeeid/$servicename"."console/$serviceid";
    
    if (!userExists($serviceid))
    {
        $error = "Cannot remove console. The $servicename service was not found.";
        return false;
    }

    if (!userExists($employeeid))
    {
        $error = "Cannot remove console. The $servicename employeeid was not found.";
        return false;
    }

    if(!is_dir($myservicespath)){
        $error="Cannot remove console. Employee is not providing $servicename console service.";
        //return false;
    } else {
        ozrmdir($myservicespath);
    }

    if (!ozlsdir("$regdir/$employeeid/$servicename"."console",$files,$dirs,$error))
    {
        $error="Cannot remove console. Error listing service entries for employee console.";
        //return false;
        $dirs = [];
    }

    if (count($dirs)==0)
    {
        global $dirprefix;
        include_once("$dirprefix/ozekiservices/subscriptions/common.php");
        if (!unSubscribeService($employeeid,$servicename."console",$errorm))
        {
            $error="Cannot remove console. Unsubscribe error.";
            if ($debug) { $error.= " ".$errorm;}
            //return false;
        }
    }

    $consolelist = "$regdir/$serviceid/$servicename"."admin/consoleusers.txt";
    if (!ozfiledelfromlist($consolelist,$employeeid,$errorm))
    {
        $error="Cannot remove console. Error deleting $servicename console entry.";
        if ($debug) { $error.= " ".$errorm;}
        //return false;
    }

    //Log
    $log = "Console access removed ($source): $serviceid, $employeeid, $reason";
    ozlog(__FILE__, "INFO", $log);

    return true;
}

//******************************************
// Load service details for console admin
//******************************************

function loadConsoleAdminDetails($servicename, &$services,&$error) 
{
    global $regdir,$myuserid;
    $path="$regdir/$myuserid/$servicename"."admin";
    if (!is_dir($path)) 
    {
        $services = [];
        return true;

    }
    if (!ozlsdir($path, $files, $dirs, $error))
    {
        $services = [];
        return false;
    }
    $services = [];
    
    foreach($dirs as $serviceid)
    {
        if (!isUserEnabled($serviceid)) continue;
        if (!loadConsoleAdminDetailsForService($servicename, $serviceid, $service,$error))
        {
            return false;
        } 
        $services[] = $service;
    }
    return true;
}

function loadConsoleAdminDetailsForService($servicename, $serviceid, &$service,&$error) 
{
    global $regdir,$myuserid;
    $path="$regdir/$myuserid/$servicename"."admin";
    $fullServicePath="$path/$serviceid/details.txt";
    if (!ozreadjson($fullServicePath,$service,$error))
    {
        $error = "Cannot read service information. $error";
        return false;
    }

    loadConsoleUsersForService($servicename,$service,$errorm);
    loadCustomersForService($servicename,$service,$errorm);
    return true;
}

function loadConsoleUsersForService($servicename,&$service,&$error)
{
    global $regdir;
    $serviceid = $service["serviceid"];
    $service["consoles"] = array();
    $path="$regdir/$serviceid/$servicename"."admin/consoleusers.txt";
    ozreadlines($path,$consoles,$error);
    foreach($consoles as $console)
    {
        $service["consoles"][$console] = GetName($console);
    }
}

function loadCustomersForService($servicename,&$service,&$error)
{
    global $regdir;
    $serviceid = $service["serviceid"];
    $service["customers"] = array();
    $path="$regdir/$serviceid/$servicename/subscribers.txt";
    ozreadlines($path,$lines,$error);
    foreach($lines as $customer)
    {
        $service["customers"][$customer] = GetName($customer);
    }
}

//******************************************
// Load service details for console user
//******************************************

function loadConsoleDetails($servicename, $userid, &$services,&$error) 
{
    global $regdir;
    $path="$regdir/$userid/$servicename"."console";
    
    if (!is_dir($path)) 
    {
        $services = [];
        $error = "Cannot find any sales console subscriptions";
        return true;

    }

    if (!ozlsdir($path, $files, $dirs, $error))
    {
        $services = [];
        $error = "Cannot load sales console subscriptions";
        return false;
    }

    $services = [];
    foreach($dirs as $serviceid)
    {
        if (!ismd5($serviceid)) continue;
        if (!isUserEnabled($serviceid)) continue;
        $p="$path/$serviceid/details.json";
        if (!ozreadjson($p,$service,$error))
        {
            $error = "Cannot read service information. $error";
            return false;
        }

        $services[] = $service;
    }

    return true;
}

//******************************************
// Load RSA key of customer
//******************************************
//servicename: sales
//userid: md5
function loadRSAKeyOfUser_SharedToMyConsole($servicename,$userid,&$userrsakey,&$error)
{
	global $myuserid;
	if (!loadConsoleDetails($servicename, $myuserid, $services, $error)) 
	{
		$error = "Cannot load user key. No $servicename consoles installed. $error";
		return false;
	}

    $cnt = count($services);
    if ($cnt==0)
    {
        $error = "Cannot load user key. No $servicename consoles installed.";
        return false;    
    }

	foreach($services as $service)
	{
		$serviceid = $service["serviceid"];
        //Load private key of userid, that was shared to serviceid
		if (ozloadrsaprivatekeyofsharedto($userid,$serviceid,$userrsakey,$error))
			return true;
	}

	$error = "Cannot load user key. No $servicename consoles have user access.";
	return false;
}

?>
