<?php
global $sysdir;
include_once("$sysdir/services/console.php");

function displayConsoleListItem($servicename, $serviceid, $employeename, $employeeid)
{
    global $owpn;
    $url = "index.php?owpn=$owpn&myaction=delconsole&servicename=$servicename&serviceid=$serviceid&consoleid=$employeeid";
    $dellink = "<a href='$url' onclick='return confirm(\"Are you sure you wish to delete this console?\");'>[Del]</a>";
    return "$employeename ($employeeid) $dellink";
}

function printOfficerList($servicename, $consoleListItemDisplayFunc="displayConsoleListItem")
{
    global $owpn,$myaction,$serviceid,$consoleid;

    $ucservicename = ucfirst($servicename);

    //************************************************************
    // Delete console 
    //************************************************************

    loadmyaction();
    if ($myaction=='delconsole')
        {
        $source = "salesadmin/consoles/consolelist.php";

        loadReqParams("serviceid","consoleid");
        $reason = "Admin delete request";

        $ret = delconsole($source,$servicename,$serviceid,$consoleid,$reason,$error);

        if ($ret)
        {
            echo displaySuccess("Success", "$ucservicename console deleted successfully");
            return;
        } 
        else
        {
            echo displayError("Console delete failed",$error);
            return;
        }
    }

    //************************************************************
    // Display
    //************************************************************

    //$addBtn="<a class='btn btn-success' href=index.php?owpn=$owpn&action=consoleadd>Add...</a>";
    $ret = card(ucfirst($servicename)." admin: Console list");
    $ret .= printAllUserServiceOfficers($servicename, $consoleListItemDisplayFunc);
    $ret .= cardend(); 

    return $ret;
}

//*****************************************************************
// Officers
//*****************************************************************

function printAllUserServiceOfficers($servicename, $consoleListItemDisplayFunc)
{
    if (!loadConsoleAdminDetails($servicename,$services,$error)) 
    {
        return displayError("Display error","Cannot load console information. ".$error);
    }

    $servicenameuc = ucfirst($servicename);

    $returnHTML="";
    if(isEmpty($services))
    {
        $setuphelp =<<<SETUPHELP
<H4>Please setup your service</H4>
<p>
You can setup your $servicenameuc service by clicking on "Add service" in the navbar. Once your 
service has been setup you will be able to add subordinates, who help you provide this service.
Subordinates will be able to work with people interested in your service. As the service administrator
your job will be to create and manage subordinate accounts.
</p>

SETUPHELP;
        return $setuphelp;
    }

    foreach($services as $service)
    {
        $serviceHTML=printUserServiceOfficers($servicename, $service,  $consoleListItemDisplayFunc);
        $returnHTML .= $serviceHTML;
    }
    return $returnHTML;
}


function printUserServiceOfficers($servicename, $service,  $consoleListItemDisplayFunc)
{
    global $owpn;
    $serviceTitle=$service["title"];
    $serviceid=$service["serviceid"];
    $officers = printUserServiceConsoleEmployees($servicename, $service, $consoleListItemDisplayFunc);

    $returnHTML=<<<SERVICEHTML
    <div class="row mt-2">
        <div class="col">
            <div style="font-size:120%;font-weight: bold;">
            $serviceTitle ($serviceid)
            </div>
            <div style="font-size:80%;">
            <b style="color:#303060">Officers</b>
            $officers
            </div>
        </div>
    </div>
SERVICEHTML;
return $returnHTML;
}

function printUserServiceConsoleEmployees($servicename, $service, $consoleListItemDisplayFunc="displayConsoleListItem")
{
    global $owpn;

    if (!is_array($service) && ismd5($service))
    {
        $serviceid = $service;
        if (!loadConsoleAdminDetailsForService($servicename, $serviceid, $service, $error))
        {
            return "Cannot print console employee list. ".$error;
        }
    }

    if (!is_array($service["consoles"]) || count($service["consoles"])==0) return "";

    $serviceid=$service["serviceid"];
    $serviceConsoles = "<ol>";
    foreach($service["consoles"] as $employeeid=>$employeename)
    {
        $serviceConsoles .= "<li>".$consoleListItemDisplayFunc($servicename,$serviceid,$employeename,$employeeid)."</li>";
    }
    $serviceConsoles .= "</ol>";
    return $serviceConsoles;
}




?>