<?php
global $sysdir;
include_once("$sysdir/services/console.php");

//*******************************************
// Display / no recruitment service provided
//*******************************************
function displayOrgServiceItem($service,$first)
{
    global $owpn;

    $title = $service["title"];
    $serviceid = $service["serviceid"];
    $enabled = $service["enabled"];

    if (!$enabled) return "";
    $bordertop = $first ? "border-top: 1px solid #ceceff" : "";

    $ret = <<<SERVICITEMEND
    <div class="row mt-2 mb-2 ms-0 ps-0 pt-2 pb-2 me-0 pe-0" style="border-bottom: 1px solid #ceceff; $bordertop">
        <div class="col-8 ms-0 mt-2 ps-0"><h4>$title</h4></div>
        <div class="col-4 mt-1 ms-0">
            <a href="index.php?owpn=$owpn&serviceid=$serviceid"><div class="btn btn-primary">Open</div></a>
        </div>
    </div>
SERVICITEMEND;

    return $ret;
}


function displayOrgServiceSelector($services)
{
    $intro = <<<ENDINTRO
    Please select the service you wish to work with. 
    To select a service, you need to click on the blue "Open" button.
ENDINTRO;

    $first = true;
    $orglist = "<div style='max-width:600px'>";
    foreach($services as $service)
    {
        $orglist .= displayOrgServiceItem($service,$first);
        $first = false;
    }
    $orglist .= "</div>";

    $ret = card("Company");
    $ret .= $intro;
    $ret .= $orglist;
    $ret .= cardend();
    return $ret;
}

//*******************************************
// Display / no recruitment service provided
//*******************************************

function displayNoOrgServiceProvided($offer)
{
    $servicetitle = $offer["title"];
    $officername = lcfirst($offer["officername"]);
    $officertasks = $offer["officertasks"];
    
$noinfo = <<<NOINF
    Currently you are not providing $servicetitle for any organization. 
    Once an organization owner promotes you to become a $officername, 
    you will be able to manage the $servicetitle of that organization.
    You will be able to $officertasks.
NOINF;

    $ret = card("$servicetitle I provide");
    $ret .= $noinfo;
    $ret .= cardend();
    return $ret;
}


//*******************************************
// Select organizations
//*******************************************
function displayOrgSelector($offer)
{
    global $myuserid;

    $servicename = $offer["name"];

    if (loadConsoleDetails($servicename, $myuserid, $services,$error)) 
    {
        $ret = "";
        if (count($services)==0) {
          return displayNoOrgServiceProvided($offer);
        }

        return displayOrgServiceSelector($services);
    } 

    return $error;
}

//**************************************************************
// Service id loaded by navbar
//**************************************************************
$serviceidavailable = true;
if (isEmpty($serviceid)) 
{
    $serviceidavailable = false;
    global $serviceid;
    loadReqParams("serviceid");
}

if (!isEmpty($serviceid))
{
    loadSelectedServiceDetails($serviceid,$orgservice,$error);
    if ($orgservice["servicename"] != $offer["name"]) $serviceid = "";
}

if (isEmpty($serviceid))
{
    if (loadConsoleDetails($offer["name"], $myuserid, $services,$error)) 
    if (count($services)==1)
    {
       $serviceid = $services[0]["serviceid"];
    }
} 

if (isEmpty($serviceid))
{
    echo displayOrgSelector($offer);
    return true;
}

if (!isEmpty($serviceid))
{
    loadSelectedServiceDetails($serviceid,$orgservice,$error);
}

setSessionRequestParameter("serviceid",$serviceid);

return false;
?>
