<?php
function printHtmlHeaderReact($servicename,$serviceversion)
{
    $pagestart=printHtmlPageStart();
    $headstatic="";
    $staticassets=getStaticAssetsReact();
    foreach($staticassets['script'] as $asset)
    {
        $headstatic.="<script src=\"$asset\"></script>\n";
    }
    foreach($staticassets['stylesheet'] as $asset)
    {
        $headstatic.="<link href=\"$asset\" rel=\"stylesheet\">\n";
    }
    foreach($staticassets['icon'] as $asset)
    {
        $headstatic.="<link rel=\"icon\" type=\"image/png\" href=\"$asset\">\n";
    }
    $headreact=include_react_assets("$servicename/attachments/$serviceversion/home");
    return<<<HTML
$pagestart
    <link rel="preconnect" href="https://fonts.gstatic.com">
    $headstatic
    $headreact
</head>
<body>
HTML;
}

function printHtmlFooterReact()
{
    return<<<HTML
</body>
</html>
HTML;
}

function getStaticAssetsReact()
{
    return [
        "script" => [
            "/ozekiservices/system/attachments/1/ozeki.4.js",
        ],
        "stylesheet" => [
            "https://fonts.googleapis.com/css?family=Open+Sans:300,400,500,600,700%7cPoppins:300,400,500,600,700,800,900&display=swap",
            "/ozekiservices/system/attachments/1/falcon/assets/css/theme.min.css",
            "/ozekiservices/system/attachments/1/falcon/assets/css/user.min.css",
            "/ozekiservices/system/attachments/1/ozeki.3.css",
        ],
        "icon" => [
            "/ozekiservices/system/attachments/1/ozeki-logo.png",
            "/ozekiservices/system/attachments/1/img/white_ozeki_logo_portable_web_transparent_text.png",
        ],
    ];
}

function include_jsconsts()
{
    global $siteurl,$myuserid;
echo <<<JSEND
    <script>
    siteurl = "$siteurl";
    myuserid = "$myuserid";
    </script>
JSEND;

}

function include_react($reactstaticroot)
{
    global $servicesdir;

    $jsdir = "$servicesdir/$reactstaticroot/static/js";
    ozlsdir($jsdir,$files,$dirs,$error);
    foreach($files as $file)
    {
        if (!preg_match("/.*js$/",$file)) continue;
        echo "<script defer=\"defer\" src=\"/ozekiservices/$reactstaticroot/static/js/$file\"></script>\r\n";
    }

    $cssdir = "$servicesdir/$reactstaticroot/static/css";
    ozlsdir($cssdir,$files,$dirs,$error);
    foreach($files as $file)
    {
        echo "<link rel=\"stylesheet\" href=\"/ozekiservices/$reactstaticroot/static/css/$file\">\r\n";
    }
}

function include_react_index($staticrootpath)
{
    global$servicesdir;
    $f="$servicesdir/$staticrootpath/static/index.html";
    if(!ozreadfile($f,$content,$error)) {
        return "<!-- Not found: $f -->";
    }
    return $content;
}

function include_react_main($staticrootpath)
{
    global$servicesdir;
    $staticdir="$servicesdir/$staticrootpath/static/";
    if(!ozlsdir($staticdir,$files,$dirs,$error))return;
    $ret = "";
    foreach($files as $f)
    {
        if(!preg_match("/main\.[a-fA-F0-9]+\.js/",$f))continue;
        $ret .= "<script type=\"module\" src=\"/ozekiservices/$staticrootpath/static/$f\"></script>";
        break;
    }
    return $ret;
}

function include_react_assets($staticrootpath)
{
    global $servicesdir;
    
    $assets_file = "$servicesdir/$staticrootpath/assets.json";
    
    if (!file_exists($assets_file)) {
        return "<!-- Not found: $assets_file -->";
    }
    
    $assets_content = file_get_contents($assets_file);
    if ($assets_content === false) {
        return "<!-- Failed to read: $assets_file -->";
    }
    
    $assets = json_decode($assets_content, true);
    if ($assets === null) {
        return "<!-- Failed to parse JSON: $assets_file -->";
    }
    
    $html = "";

    if (isset($assets['main']['css']) && is_array($assets['main']['css'])) {
        foreach ($assets['main']['css'] as $css_file) {
            $html .= "<link href=\"$css_file\" rel=\"stylesheet\">\r\n";
        }
    }

    if (isset($assets['main']['css']) && is_string($assets['main']['css'])) {
        $csspath = $assets['main']['css'];
        $html .= "<link href=\"$csspath\" rel=\"stylesheet\">\r\n";
    }

    if (isset($assets['main']['js']) && is_array($assets['main']['js'])) {
        foreach ($assets['main']['js'] as $js_file) {
            $html .= "<script defer=\"defer\" src=\"$js_file\"></script>\r\n";
        }
    }
    return $html;
}
?>