<?php

//************************************************************
// Navbar section title
//************************************************************

function navbarSectionTitle($name, $style='')
{
$st = <<<SECTITLE
<div class="row navbar-vertical-label-wrapper mt-3 mb-0"> 
    <div class="col-auto navbar-vertical-label" style="$style">$name</div> 
</div>
SECTITLE;
return $st;
}

//************************************************************
// Navbar divider
//************************************************************

function navbarDivider()
{
    return '<div class="col ps-0"><hr class="mb-0 navbar-vertical-divider"></div>';
}

//************************************************************
// Navbar link
//************************************************************

function navbarLink($url, $title, $icon="<span class='fas fa-calendar-alt'></span>", $style="")
{
$link = <<<NAVLINK
<a class="nav-link" href="$url" role="button" aria-expanded="false">
    <div class="d-flex align-items-center">
        <span class='nav-link-icon'>$icon</span>
        <span class="nav-link-text ps-1" style='$style'>$title</span>
    </div>
</a>
NAVLINK;
return $link;
}

//************************************************************
// Navbar page link
//************************************************************

function navbarPageLink($pagenumber,$urlparams="",$title=null,$icon=null)
{
    global $pagename,$owpn,$owpname,$pagelink;
    if (ozstartswith($pagenumber,"page_")) 
    {
        $pagen = $pagenumber;
        global $$pagenumber; 
        $pagenumber=$$pagenumber;
        if (isEmpty($pagenumber))
        {
            return "<div>Unknown page: $pagen</div>";
        }
    }
    if (isEmpty($icon)) $icon = navbarIcon($pagenumber); else $icon = navbarIconFile($icon);
    if (isEmpty($title)) $title = $pagename[$pagenumber];
    if (!isEmpty($urlparams)) $urlparams = "&$urlparams";
    $pl = $pagelink[$pagenumber];
    $url = "index.php?owpn=$pl$urlparams&nocache=".ozrndstr();

    $paramspresent = (ozstrcontains($_SERVER['REQUEST_URI'],$urlparams)) ? true : false;
    if (isEmpty($urlparams)) $paramspresent = true;
    $style = (($pagenumber==$owpn || $pagenumber==$owpname) && ($paramspresent)) ? "color:#303060; font-weight:800" : "";

    return navbarLink($url, $title, $icon, $style);
}

//************************************************************
// Navbar icon
//************************************************************
function navbarIconFile($iconfile)
{
    return "<img src='$iconfile' style='width: 1rem; opacity: .6;'>";
}


function navbarIcon($pagenumber)
{
    global $pageicon;
    $icon = $pageicon[$pagenumber];

    if ($icon=="") 
	{
		$icon = "<span class='fas fa-calendar-alt'></span>";
	} 
	else if (!ozstartswith($icon,"<"))
	{
		$icon = "<img src='$icon' style='width: 1rem; opacity: .6;'>";
	}
	
	if ($icon!="")
	{
		$icon = "<span class='nav-link-icon'>$icon</span>";
	}

    return $icon;
}

?>