<?php
include_once("$sysdir/navbar/navbar.php");

$debugsitemap = false;
$smdebuginfo = "";

#*******************************************************************************
# Identify current service related variables
#*******************************************************************************

$currentService = $pageservice[$owpn];
$currentHomeName = "page_".$currentService."_home";
$currentHome = (isset($$currentHomeName)) ? $$currentHomeName : "";
$currentRootName = "page_service_".$currentService;
$currentRoot = $$currentRootName;

#*******************************************************************************
# Sitemap build support functions
#*******************************************************************************
function isPageVisible($pagenumber)
{
  global $pagehidden;
  if (array_key_exists($pagenumber,$pagehidden)) return !$pagehidden[$pagenumber];
  return true;
}

function hasVisibleChildren($page)
{
  global $pchildren;
  if (!array_key_exists($page,$pchildren)) return false;
  $children = $pchildren[$page];
  if (!is_array($children) || count($children)==0) return false; 
  foreach ($children as $pagenumber)
  {
      if (isPageVisible($pagenumber)) return true;
  }
  return false;
}

function isCurrentService($pagenumber)
{
  global $currentHome,$currentService,$currentRoot,$pageservice;
  if (isEmpty($currentHome)) return true;
  if ($currentRoot==$pagenumber) return true;
  if (array_key_exists($pagenumber,$pageservice) && $pageservice[$pagenumber] == $currentService) return true;
  return false;
}

function displayNavItem($pagenumber,$name,$level)
{
  global $debugsitemap,$smdebuginfo;
  if ($debugsitemap) {
    $smdebuginfo .= "[DN] Navitem: $name</span><br>"; 
    $smdebuginfo .= "[DN] Level: $level</span><br>"; 
  }
  $ret = '<li class="nav-item">';
  $ret .= navbarSectionTitle($name);
  $ret .= navbarDivider();
  $ret .= smPrintChildren($pagenumber,"",$level+1);
  $ret .= '</li>';
  $ret .= "\r\n";
  return $ret;
}


#********************************************
# I.1 Display dashboard displaySitemap
# ------------------------------------
# 1.) A profile/navbar.php regisztrál menüpontokat
# 2.) A subscriptions/navbar.php regisztrál menüpontokat
#********************************************

function displayDashboardSitemap()
{ 
    global $navbar_dashboard;

    //$navbar_dashboard: 
    //0 => string 'createNavbarDashboard' (length=21)
    //1 => string 'createNavbarMyProfile' (length=21)

    $ret = "";
    foreach($navbar_dashboard as $navitem)
    {
      $ret .= $navitem();
    }

    return $ret;
}

#********************************************
# I.2 Add app pages to sitemap
#********************************************

function addPageToSitemap($parentid,$pagenumber,$name)
{
	global $pname,$pparent,$pchildren,$pagehidden, $debugsitemap,$smdebuginfo;
  if ($debugsitemap) {$smdebuginfo .= "[P] $pagenumber; $name<br>"; }

  $pname[$pagenumber] = $name;
  $pparent[$pagenumber] = $parentid; 
  $pchildren[$parentid][] = $pagenumber;
}

function addAppToSitemap($appname)
{ 
  global $debugsitemap,$smdebuginfo,$page_dashboard,$app,$pagename;
  if ($debugsitemap) {$smdebuginfo .= "[App] $appname<br>"; }

	$appindex = $app[$appname]["startpage"];
	if (!array_key_exists("pages",$app[$appname])) return;
	$apppages = $app[$appname]["pages"];
  if (!is_array($apppages)) return;
	addPageToSitemap($page_dashboard,$appindex,$appname);
  foreach($apppages as $page)
	{
		 addPageToSitemap($appindex,$page,$pagename[$page]);
	}   
}

#********************************************
# I.3 Display app generated
#********************************************

function displayAppSitemap()
{
    global $currentService,$app,$servicetitles,$navbarsection;

    //Main section
    $serviceTitle = $servicetitles[$currentService];

    //Organize th pages into sections
    $pages = $app[$currentService]["pages"];
    $sections = [];
    foreach($pages as $pagenumber)
    {
      if (!isPageVisible($pagenumber)) continue;
      $section = $navbarsection[$pagenumber];
      if ($section == "") $section = $serviceTitle;
      if (!array_key_exists($section,$sections)) $sections[$section] = "";
      $sections[$section] .= navbarPageLink($pagenumber);
    }

    //Print sections
    $ret = "";
    foreach($sections as $sectiontitle=>$sectioncontent)
    {
      $ret .= '<li class="nav-item">';
      $ret .= navbarSectionTitle($sectiontitle);
      $ret .= navbarDivider();
      $ret .= $sectioncontent;
      $ret .= '</li>';
    }

    return $ret;
}

#********************************************
# I.4 Display dasboard / app sitemap
#********************************************

function displaySitemap()
{
    global $currentService,$navbar,$owpn,$page_dashboard;
    if ($owpn==$page_dashboard)
    {
       return displayDashboardSitemap();
    }

    if (!is_array($navbar) || !array_key_exists($currentService,$navbar))
    {
        return displayAppSitemap();
    }

    return $navbar[$currentService]();
}

#*******************************************************************************
# II. Build sitemap
# -----------------
# 1.) Az app-okat hozzáadjuk a sitemaphez
# 2.) Meghívjuk a display sitemap eljárást
#*******************************************************************************

if ($debugsitemap) {$smdebuginfo .= "[SM] Loading apps...<br>"; }

$hideapps[] ="upload";
$hideapps[] ="dashboard";
$hideapps[] ="authentication";

foreach($app as $appname=>$pages)
{
  if (in_array($appname,$hideapps)) continue;
  addAppToSitemap($appname);
}

if (!$loggedin) return;

#********************************************
# Display / prepare
#********************************************

$dashboardlink = <<<SITEMAPDASHBOARDLINK
<li class="nav-item">
  <a class="nav-link" href="index.php?owpn=page_dashboard" aria-expanded="false">
  <div class="d-flex align-items-center"><span class="nav-link-icon"><span class="fas fa-chart-pie"></span></span><span class="nav-link-text ps-1">Dashboard</span>
  </div>
  </a>
</li>
SITEMAPDASHBOARDLINK;

$navitems = displaySitemap(); 

#********************************************
# Display
#********************************************

$ret = <<<SITEMAPEND
<nav class="navbar navbar-light navbar-vertical navbar-expand-xl navbar-card" style="max-width:250px">
  <script>
    var navbarStyle = localStorage.getItem("navbarStyle");
    if (navbarStyle && navbarStyle !== 'transparent') {
      document.querySelector('.navbar-vertical').classList.add('navbar-'+navbarStyle);
    }
  </script>
  <div class="d-flex align-items-center mt-0 mt-xl-3 mb-xl-3">
    <div class="toggle-icon-wrapper">
      <button class="btn navbar-toggler-humburger-icon navbar-vertical-toggle" data-bs-toggle="tooltip" data-bs-placement="left" 
      title="Toggle Navigation"><span class="navbar-toggle-icon"><span class="toggle-line"></span></span></button>
    </div>
    <a class="navbar-brand" href="index.php?owpn=page_dashboard">
      <div class="d-flex align-items-center"><img class="me-2" src="/ozekiservices/system/attachments/1/img/ozeki_logo_web_transparent.png" alt="" width="110" /></div>
    </a>
  </div>
  <div class="collapse navbar-collapse card" id="navbarVerticalCollapse">
    <div class="navbar-vertical-content scrollbar">
      <ul class="navbar-nav flex-column mb-3" id="navbarVerticalNav">
        $dashboardlink
        $smdebuginfo
		    <!-- Generated sitemap start -->
        $navitems
        <!-- Generated sitemap end -->

      </ul>
     </div>
  </div>
</nav>
SITEMAPEND;

echo $ret;
?>
