<?php
//************************************************************************
// Accept uploaded files by home.php
//************************************************************************

function acceptUploadedBase64Data($inputname,$destdir,$destfile,&$error,$uploadsizelimit = "10000000",$removeprefix = "data:image/png;base64,")
{
    if (!array_key_exists($inputname,$_REQUEST)) 
    {
        $error = "File upload failed. Upload data not found in POST request.";
        return false;
    }

    $inputdata=$_REQUEST[$inputname];

    $size = strlen($inputdata);
    if ($size==0)
    {
        $error = "File upload failed. The upload size is 0.";
        return false;
    }

    if($size>$uploadsizelimit) 
    {
		$sizelimit = ozkbsize($uploadsizelimit); 
        $error = "File upload failed. File size exceeds the upload limit ($sizelimit).";
        return false;
    }

    if (isEmpty($destdir))
    {
        $error = "File upload failed. Destination dir not specified.";
        return false;
    }

    if (isEmpty($destfile))
    {
        $error = "File upload failed. Destionation file not specified.";
        return false;
    }


    if (!ozmkdir($destdir,$error))
    {
        $error = "File upload failed. Could not create upload dir. '$destdir'";
        return false;
    }

    $f = "$destdir/$destfile";

	if (file_exists($f) && (!unlink($f)))
    {
		$error = "File upload failed. Could not remove previous upload.";
        return false;
	}

    //Fix base64 encoding
    $inputdata = str_replace(" ","+",$inputdata);

    //Remove prefix
    if (strpos($inputdata , $removeprefix ) === 0) 
    {
        $chop = strlen($removeprefix);
        $inputdata = substr($inputdata,$chop);
    }

    //Base64 decode
    $data = base64_decode($inputdata);
    if ($data==false)
    {
        $error = "File upload failed. Invalid base 64 data.";
        return false;
    }

    //Save file
    $fp = fopen($f,"w");
    fwrite($fp, $data);
    fclose($fp);

	return true;
}

//************************************************************
// Add upload JS once
//************************************************************

global $addeddUploadBase64Js;
$addeddUploadBase64Js = false;

function addUploadBase64Js()
{
    global $addeddUploadBase64Js;
    if ($addeddUploadBase64Js) return "";
    $addeddUploadBase64Js = true;
    return <<<UPLOADBUTTONJS
function uploadBase64Data(url,inputname,base64data) {
    var xmlHttpReq = false;
  
    if (window.XMLHttpRequest) {
      ajax = new XMLHttpRequest();
    }
    else if (window.ActiveXObject) {
      ajax = new ActiveXObject("Microsoft.XMLHTTP");
    }
  
    ajax.open("POST", url, false);
    ajax.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    ajax.onreadystatechange = function() {
      console.log(ajax.responseText);
    }
    ajax.send(inputname+ "=" + base64data);
  }
UPLOADBUTTONJS;
}

?>