<?php
//************************************************************************
// Accept uploaded files by home.php
//************************************************************************

//$uploadsizelimit = "10000000";
//$acceptextensions = array("jpg","jpeg","png");

function acceptUploadedFile($inputname,$destdir,&$destfile,&$error,$uploadsizelimit = "10000000",$acceptextensions = array("jpg","jpeg","png"))
{
    if (!array_key_exists("action",$_REQUEST)) return true;
    if ($_REQUEST["action"]!="uploaded") return true;

    if (!array_key_exists($inputname,$_FILES)) 
    {
        $error = "File upload failed. Upload data not found in POST request.";
        return false;
    }

    $file=$_FILES[$inputname];
    if ($file["size"]==0)
    {
        $error = "File upload failed. The upload size is 0.";
        return false;
    }

    if (!ozmkdir($destdir,$error))
    {
        $error = "File upload failed. Could not create upload dir.";
        return false;
    }

    $filename = $file["name"];
    $ext = pathinfo($filename, PATHINFO_EXTENSION);

    if (!in_array($ext,$acceptextensions))
    {
        $error = "File upload failed. File extension not accepted. Valid extensions: ".implode(",",$acceptextensions);
        return false;
    }

    $newfilename = date("Ymd-His")."_".ozrndstr().".".$ext;
    $f = "$destdir/$newfilename";

	if (file_exists($f) && (!unlink($f)))
    {
		$error = "File upload failed. Could not remove previous upload.";
        return false;
	}

	if($file["size"]>$uploadsizelimit) 
    {
		$sizelimit = ozkbsize($uploadsizelimit); 
        $error = "File upload failed. File size exceeds the upload limit ($sizelimit).";
        return false;
    }

    if(!move_uploaded_file($file["tmp_name"],$f))
    {
        $error = "File upload failed. Could not find uploaded temp file.";
        return false;
    }

    $destfile = $f;
	return true;
}

//************************************************************************
// Display file upload form
//************************************************************************

function displayUploadForm($inputname) 
{

    return <<<UPLOADFORMEND
<form action="index.php?owpn=page_qrmarketer_upload" method="post" enctype="multipart/form-data">
  Select image to upload:
  <input type="hidden" name="action" value="uploaded">
  <input type="file" name="$inputname" >
  <input type="submit" value="Upload Image" name="submit">
</form>
UPLOADFORMEND;
}

?>