<?php
/*
El kell készíteni a repost prevention szolgáltatást. Ennek az a célja, hogy 
ne lehessen oldal refresh-t használva, duplikálni a beküldött adatokat. 

Bevezető:
---------------
Létre kell hozni a repost.php fájlt az ozeki\lib mappában

A repost.php feladata, hogy megakadályozza a formok duplikált elküldését. 
Ezt úgy fogja megtenni, hogy minden formba beír egy random hidden input 
tag-et javascripttel. Amikor a post bejön, akkor megnézi, hogy az említett 
tag bejött-e már korábban. Ha igen, akkor megakadályozza a post-ot.

A javascript:
-------------
A javascript egy input field-et ad hozzá a formokhoz:
<input type='hidden' name='repost' value='randomstring'>;

Ha egy szolgáltatásban használni szeretnénk a repost prevention-t, 
akkor meg kell hívni a repost.php-ben levő echo enableRepostPrevention() 
eljárást, ami kiteszi a HTML-be azt a javascript-et ami végigiterál 
HTML DOM formjain és mindegyikbe beírja a fenti hidden inputot.

Duplikált post megakadályozása:
------------------------------
A repost.php isPostAllowed eljárása vizsgálja, hogy jött-e browsertől 
a hidden inputban definiált $repost érték, ha igen, akkor megnézi, hogy 
ilyen értékkel postoltak a formot mostanában, ha igen, akkor jelezzen 
ki hibát és akadályozza meg a postot.

A hiba kijelzés egy globális változó beállítását jelenti, a post 
megakadályozása a $myaction globális változó törlését jelenti. 

Load myaction
------------------------------
Jelenleg minden form adatfogadó kód maga szedi ki a $_POST-ból a 
$myaction-t. Ezt rá kell bízni a repost.php loadMyAction eljárására. 

Adat tárolás:
-------------
A random tag-eket a repost.php a $recentposts[unixtimestamp,randomstring] tömbben 
tárolja. Ezt a tömböt json_encoded formában a $datadir/sessions/repost.txt fájlban menti el. 

Mielőtt a duplikált postot vizsgálja, az 1 napnál régebbi random stringeket 
törölje a recentposts tömbből. ($debug módban a 3 percnél régebbieket). 

A repost.txt fájlban tehát a nem túl régi post random stringeket kell tárolni.
Minden post után frissíteni kell a fájlt.
*/

function enableRepostPrevention()
{
	return '<script>
	var alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";

	function generateRandomString(length) {
		result = "";
		for (var i = 0; i < length; i++) {
			var index = Math.floor(Math.random() * alphabet.length);
			result += alphabet.substring(index, index + 1);
		}
		return result;
	}

	var forms = document.getElementsByTagName("form");
	for(var i = 0; i < forms.length; i++)
	{
		var input = document.createElement("input");
		input.setAttribute("type", "hidden");
		input.setAttribute("name", "repost");
		input.setAttribute("value", generateRandomString(10));
		forms[i].appendChild(input);
	}
	</script>';
}

function updateRecentPosts($repostvalue, &$error)
{
	global $datadir, $recentposts, $debug;

	$dirError = "";
	if (!is_dir("$datadir/sessions") && !ozmkdir("$datadir/sessions", $dirError)) {
		$error = "Error creating destination directory!<br>";
		if ($debug) $error .= "Error creating destination directory: $datadir/session! "."$dirError";
		return;
	}

	if (!file_exists("$datadir/sessions/repost.txt")) {
		$recentposts = array();
	}

	if (file_exists("$datadir/sessions/repost.txt")) {
		if (!($file = fopen("$datadir/sessions/repost.txt", "r"))) {
			$error = "Error opening the file for reading!<br>";
			if ($debug) $error .= "Error opening the file: $datadir/sessions/repost.txt";
			return;
		}

		$content = fread($file, filesize("$datadir/sessions/repost.txt"));
		$recentposts = json_decode($content, true);
	}

    if (!($file_tmp = fopen("$datadir/sessions/tmp.txt", "w"))) {
        fclose($file);
        $error = "Error opening the file for writing!<br>";
        if ($debug) $error .= "Error opening the file: $datadir/sessions/tmp.txt";
        return;
    }

	foreach ($recentposts as $array_key => $array_value) {
		if ($debug) {
			if (strtotime($array_key) < strtotime("now -3 minutes") || $array_value == null) {
				unset($recentposts[$array_key]);
			}
		} else {
			if (strtotime($array_key) < strtotime("now -1 day") || $array_value == null) {
				unset($recentposts[$array_key]);
			}
		}
	}

	if ($repostvalue != null)
	{
		$recentposts[date("Y-m-d H:i:s")] = $repostvalue;
	}
	$data = json_encode($recentposts);
	fwrite($file_tmp, $data);
	if (isset($file)) fclose($file);
	fclose($file_tmp);

	rename("$datadir/sessions/tmp.txt", "$datadir/sessions/repost.txt");
}

function isPostAllowed($repostvalue, &$error)
{
	global $repostError, $datadir, $debug;

	if (!file_exists("$datadir/sessions/repost.txt")) return true;

	$repostError = "";

	if (!($file = fopen("$datadir/sessions/repost.txt", "r"))) {
		$error = "Error opening the file for reading!<br>";
		if ($debug) $error .= "Error opening the file: $datadir/sessions/repost.txt";
		return;
	}

	$content = fread($file, filesize("$datadir/sessions/repost.txt"));
	$recentposts = json_decode($content, true);
	if (!is_array($recentposts)) return true;

	$postcounts = array_count_values($recentposts);

	if ($postcounts[$repostvalue] > 1) return false;

	return true;
}

function loadMyAction()
{
	global $myaction;

	if ($myaction!=null) return;
	$myaction = null;
	if (isset($_REQUEST["myaction"]))
	{
		$myaction = $_REQUEST["myaction"];
		updateRecentPosts($_REQUEST["repost"], $error);
		if ($error != null) return;
	}

	if ($myaction != null && !isPostAllowed($_REQUEST["repost"], $error))
	{
		if ($error != null) return;
		$myaction = null;
	}

	return $myaction;
}
?>