<?php
// ******************************************************
// Entity / Table generation
// ******************************************************
function entDisplayTableHeaderLabel($a)
{
    return $a["listlabel"] ?? $a["label"] ?? "";
}

function entDisplayTableHeader($ent)
{ 
    $entid = md5($ent["dir"]);

    $ret = <<<SELECTALLSCRIPT
    <script>

    function selectAllCheckboxes(checkbox,entid)
    {
        var rows = document.getElementsByName(entid);
        for (const row of rows) 
        { 
            row.checked = checkbox.checked;
        }
    }
    </script>
SELECTALLSCRIPT;

    $ret .= "<div class='row g-0 align-items-center py-2 position-relative bg-white fw-bold d-none d-md-flex border-bottom border-400'>";

    if (!array_key_exists("checkbox",$ent) || $ent["checkbox"]) 
    {
        $ret .= "<div class='col d-none d-md-block' style='max-width:40px'>";
        $ret .= "<input type='checkbox' onclick='selectAllCheckboxes(this,\"$entid\")'>";
        $ret .= "</div>";
    }

    $ret .= "<div class='col-md d-none d-md-block' style='max-width:40px'></div>";

    $attrs = $ent["a"];
    foreach($attrs as $a)
    {
        if (!array_key_exists("list",$a)) continue;
        if (!$a["list"]) continue;
        $colclass = array_key_exists("colclass",$a) ? $a["colclass"] : "col-md ps-2";
        $colstyle = array_key_exists("colstyle",$a) ? "style='".$a["colstyle"]."'" : "";
        $ret .= "<div class='$colclass' $colstyle>";
        $ret .= entDisplayTableHeaderLabel($a);
        $ret .= "</div>";
    }

    $ret .= "<div class='col-md'> </div>";
    $ret .= "</div>";
    return $ret;
}

function displayDelSelectedButton($ent)
{
    global $owpname,$linkextra;
    $entid = md5($ent["dir"]);
    $formname = $ent["name"];
    $formaction = "formaction_$formname";
    $linkextra = getLinkExt($ent);
    $nocache = nocache();
    $urldel="index.php?owpn=$owpname&$formaction=delete$linkextra$nocache";

    $ret = <<<DELSELBUTTON
    <script>

    function postData(url,postdataKeyValues)
    {
        var form = document.createElement('form');
        form.style.visibility = 'hidden'; // no user interaction is necessary
        form.method = 'POST'; // forms by default use GET query strings
        form.action = url;
        for (var key in postdataKeyValues) 
        {
            var input = document.createElement('input');
            input.name = key;
            input.value = postdataKeyValues[key];
            form.appendChild(input); // add key/value pair to form
        }
        document.body.appendChild(form); // forms cannot be submitted outside of body
        form.submit();
    }

    function getSelectedItemIds(entid)
    {
        var rows = document.getElementsByName(entid);
        var selected = [];
        for (const row of rows) 
        { 
            var selid = row["id"];
            if (!row.checked) continue;
            selid = selid.substring(4);
            selected.push(selid);
        }
        return selected;
    }


    function delSelectedItems(entid)
    {
        if (!confirm('Are you sure you want to delete the selected items?')) return;
        console.log("Deleting items "+entid);
        var ids = getSelectedItemIds(entid);
        if (ids.length==0) return;
        var idlist = ids.join(",");
        console.log("Deleting: "+idlist); 
        var data = [];
        data["objid"] = idlist;
        postData("$urldel",data)
    }

    </script>

    <button class="btn btn-danger" onclick="delSelectedItems('$entid')">Delete</button>
DELSELBUTTON;
    return $ret;
}

function entDisplayTableFooter($ent)
{
    $delSelectedButton = displayDelSelectedButton($ent);

    $ret = <<<TABLEFOOTER

    <div class='row g-0 px-2 py-2 align-items-center position-relative  border-400 fw-bold d-none d-md-flex' style="border-radius: 0rem 0rem .375rem .375rem; background-color:#c9daff">
    <div class='col-3 d-none d-md-block'>
    $delSelectedButton
    </div>
    </div>
TABLEFOOTER;
    return $ret;
}

function getLinkExt($ent,$ignoreparams=[])
{
    $linkextra = (array_key_exists("linkextra",$ent)) ? $ent["linkextra"] : "";
    if (!isEmpty($linkextra) && !ozstartswith($linkextra,"&")) $linkextra = "&".$linkextra;
    $linkextra .= getAutoLinkExtra($ent,$ignoreparams);
    return $linkextra;
}

function getAutoLinkExtra($ent,$ignoreparams=[])
{
    if (!array_key_exists("autoextra",$ent)) return "";
    return getLinkExtra($ignoreparams);
}

function entDisplayUpdateLinks($ent,$obj)
{
    global $owpname,$debug;
    $formname = $ent["name"];
    $formaction = "formaction_$formname";
    $objid = $obj["id"];

    $linkextra = getLinkExt($ent);
    $editview = (array_key_exists("editbutton",$ent)) ? $ent["editbutton"] : true;
    $editview = (array_key_exists("editbutton",$obj)) ? $obj["editbutton"] : $editview;
    $delview = (array_key_exists("delbutton",$ent)) ? $ent["delbutton"] : true;
    $delview = (array_key_exists("delbutton",$obj)) ? $obj["delbutton"] : $delview;
    $nocache = nocache();

    $linkedit = "";
    if ($editview) 
    {
        $urledit="index.php?owpn=$owpname&$formaction=edit&objid=$objid";
        $linkedit = "<a href='$urledit$linkextra&tableaction_$formname=hide$nocache' class='float-start'><button class='btn btn-primary me-1 mb-2'>Edit</button></a>";
    }

    $linkdel = "";
    if ($delview) {
        $urldel="index.php?owpn=$owpname&$formaction=delete&objid=$objid";
        $confirm = $debug ? "" : "onclick=\"return confirm('Are you sure you want to delete this item?');\"";
        $linkdel = "<a href='$urldel$linkextra$nocache' $confirm class='d-block d-md-none float-start' ><button class='btn btn-danger'>Del</button></a>";
    }

    if (!$editview && !$delview) return "";
    $width="70px";
    //if ($editview && $delview) $width="135px"; else $width="70px";
    return "<div class='float-start' style='min-width:$width;'>$linkedit $linkdel</div>";
}


function entDisplayAttrStoredValue($ent,$attr,$obj)
{
    $funcname = "";
    if (isEmpty($funcname))
        $funcname = "attr".ucfirst($attr["type"])."DisplayValue";

    if (!function_exists($funcname))
        $funcname = "attrDisplayValue";

    return $funcname($ent,$attr,$obj);
}

function entDisplayAttrValue($ent,$attr,$obj)
{
    if (!isset($attr["type"])) return "";

    $funcname = "";
    if (array_key_exists("display",$attr))
        $funcname = $attr["display"];

    if (isEmpty($funcname))
        $funcname = "attr".ucfirst($attr["type"])."DisplayValue";

    if (!function_exists($funcname))
        $funcname = "attrDisplayValue";

    return $funcname($ent,$attr,$obj);
}

function entListItemStyle($ent,$obj)
{
    global $objid;
    if ($objid=="") return "";
    if ($obj["id"] != $objid) return "";
    return "background-color:yellow";
}

function getListItemStyle($ent,$obj)
{
    $func = (array_key_exists("listitemstylefunc",$ent)) ? $ent["listitemstylefunc"] : "entListItemStyle";
    $ret = $func($ent,$obj);
    if ($ret == "") return "";
    return "style='$ret'";
}

function entDisplayTableRow($ent,$obj,$pos)
{
    $entid = md5($ent["dir"]);
    $objid = $obj["id"];
    $drag = entAddDragDrop($ent,$obj);
    $style = getListItemStyle($ent,$obj);

    $bordertop = ($pos==1) ? "" : "border-top border-400";

    $ret = "<div id='$objid' class='row g-0 align-items-center py-2 position-relative $bordertop' $style $drag>";

    //Checkbox
    if (!array_key_exists("checkbox",$obj) || $obj["checkbox"]==true) 
    {
        $ret .= "<div class='col d-none d-md-block' style='max-width:40px'>";
        $ret .= "<input type='checkbox' id='sel_".$obj['id']."' name='$entid''>";
        $ret .= "</div>";
    }

    //Pos
    $ret .= "<div class='col d-none d-lg-block' style='max-width:40px'>";
    $ret .= $pos.".";
    $ret .= "</div>";

    //Cols
    $attrs = $ent["a"];
    foreach($attrs as $a)
    {
        if (!array_key_exists("list",$a)) continue;
        if (!$a["list"]) continue;

        $colclass = array_key_exists("colclass",$a) ? $a["colclass"] : "col-md ps-md-2";
        $colstyle = array_key_exists("colstyle",$a) ? "style='".$a["colstyle"]."'" : "";
        $ret .= "<div class='$colclass' $colstyle>";
        $ret .= entDisplayAttrValue($ent,$a,$obj);
        $ret .= "</div>";
    }

    $ret .= "<div class='col-md ps-lg-2 mt-3 mt-lg-0 d-flex justify-content-start justify-content-lg-end'>";
    $ret .= entDisplayUpdateLinks($ent,$obj);
    $ret .= "</div>";
    $ret .= "</div>\r\n";

    return $ret;
}

function entCreateNewButton($ent)
{
    global $owpname;
    $formname = $ent["name"];
    $formaction = "formaction_$formname";
    $linkextra = getLinkExt($ent);
    $nocache = nocache();

    $urlnew="index.php?owpn=$owpname&$formaction=new$linkextra&tableaction_$formname=hide$nocache";
    $linknew = "<a href='$urlnew'><button class='btn btn-primary mb-2'>Create new</button></a>";
    return $linknew;
}

function entSortByOrder($a,$b)
{
    if (!isset($a["order"])) return 0;
    if (!isset($b["order"])) return 0;
	if ($a["order"]<$b["order"]) return -1;
	if ($a["order"]>$b["order"]) return 1;
	return 0;
}

function entSortAttributes(&$ent)
{
    if (array_key_exists("attrsorted",$ent) && $ent["attrsorted"]) return;
    $attrs = $ent["a"];
    if (!is_array($attrs)) return;
    usort($attrs, "entSortByOrder");
    //var_dump($attrs);
    $ent["a"] = $attrs;
    $ent["attrsorted"] = true;
}

function entCardTitle($ent)
{
    $defaulttitle = array_key_exists("titleplural",$ent) ? $ent["titleplural"] : $ent["title"];
    $title = (array_key_exists("titlefunc",$ent)) ? $ent["titlefunc"]($ent) :$defaulttitle;
    return $title;
}

function executeOnListedEvent(&$ent,&$items,&$error)
{
    foreach($items as $obj)
    {
        if (!entExecuteEventHandlerOnListed($ent,$obj,$error)) return false;
    }

    if (array_key_exists("reload",$ent))
    {
        entLoadObjs($ent,$items,$error);
    }
    return true;
}

//*************************************************************
// Display table only
//*************************************************************

function entDisplayTable(&$ent)
{
    entSortAttributes($ent);
    $loadSuccess = entLoadObjs($ent,$items,$error);
    if (!$loadSuccess || count($items) == 0) return "";

    executeOnListedEvent($ent,$items,$error);

    $pos = 1;
    $ret .= entDisplayTableHeader($ent);

    foreach($items as $item)
    {
        $ret .= entDisplayTableRow($ent,$item,$pos++);
    }

    return $ret;
}

//*************************************************************
// Display empty table card
//*************************************************************
function entGetWidth($ent)
{
    if (!array_key_exists("width",$ent)) return "1000px";
    return $ent["width"];
}

function entDisplayEmptyTable($ent,$filterform)
{
    $title = entCardTitle($ent);

    $ret = "<div style='max-width:".entGetWidth($ent).";'>";
    $ret .= card($title, "","#c9daff","mb-3","bg-light p-0 m-0");
    if ($filterform != "") $ret .= "<div class='py-2 px-2' style='background-color:#dddddd;width:100%;'>$filterform</div>";
    $ret .= "<div class='p-2 pb-3 pt-2'>";
    $ret .= "<div class='mb-2'>";
    if (array_key_exists("descriptionnew",$ent) && !isEmpty($ent["descriptionnew"])) 
    {
        $ret .= $ent["descriptionnew"];
    } else {
        $ret .= <<<DESCNEW
        If you wish to create a new record, click on the 'Create new' button. 
        This will bring up a form you can fill out.
DESCNEW;
    }
    $ret .= "</div>";
    $ret .= entCreateNewButton($ent);
    $ret .= "</div>";
    $ret .= cardend($ent);
    $ret .= "</div>";
    return $ret;
}

//*************************************************************
// Count visible items
//*************************************************************
function isItemVisible($item)
{
    if (!array_key_exists("listvisible",$item)) return true;
    if ($item["listvisible"]==true) return true;
    return false;
}

function countVisibleItems($items)
{
    $cnt = 0;
    foreach($items as $item)
    {
        if (isItemVisible($item)) $cnt++;
    }
    return $cnt;
}

//*************************************************************
// Display table card
//*************************************************************

function entDisplayTableCard(&$ent)
{
    $tableactionname = "tableaction_".$ent["name"];
    global $$tableactionname;
    if (isEmpty($$tableactionname)) loadReqParams($tableactionname);
    if ($$tableactionname == "hide") return "";

    $obj = "dummy";
    entExecuteEventHandler("ondisplaytable",$ent,$obj,$error);

    entSortAttributes($ent);
    $filterform = entDisplayFilterForm($ent);
    $loadSuccess = entLoadObjs($ent,$items,$error);
    $ret = "";
    if (!$loadSuccess && isDebug())
    {
        $ret .= displayWarningbar($error);
    }

    if (!$loadSuccess && countVisibleItems($items) == 0)
    {
        $ret .= entDisplayEmptyTable($ent,$filterform );
        return $ret;
    }

    executeOnListedEvent($ent,$items,$error);

    $pos = 1;
    $title = entCardTitle($ent);
    $createbutton = (!array_key_exists("createbutton",$ent) || $ent["createbutton"]) ? entCreateNewButton($ent) : "";

    $ret = "<div style='max-width:".entGetWidth($ent).";'>";
    $ret .= card($title, $createbutton,"#c9daff","mb-3","bg-light p-0 m-0");
    if ($filterform != "") $ret .= "<div class='py-2 px-2' style='background-color:#dddddd;width:100%;'>$filterform</div>";
    $ret .= "<div class='p-2 pb-3 pt-2'>";
    $ret .= entDisplayTableHeader($ent);
    foreach($items as $item)
    {
        if (!isItemVisible($item)) continue;
        $ret .= entDisplayTableRow($ent,$item,$pos++);
    }
    
    $ret .= "</div>";
    $ret .= entDisplayTableFooter($ent);
    $ret .= cardend();
    $ret .= "</div>";

    return $ret;
}

?>
