<?php
// ******************************************************
// Single json file store engine. To use:4
// $ent["storeengine"] = "singlejson";
// ******************************************************

function getDataFile_singlejson($ent)
{
    global $datadir;
    $dir = $datadir.$ent["dir"];
    if (!is_dir($dir)) ozmkdir($dir,$error);
    $filename = ozpathcombine($dir,"items.json"); 
    return $filename;
}

// ******************************************************
// Save object
// ******************************************************

function entSaveObjs_singlejson($ent,$objs,&$error)
{
    if (!is_array($objs) || count($objs)==0) 
    {
        $error = "No object provided to save";
        return false;
    }

    if (!entLoadObjs_singlejson_noconvert($ent,$objscurrent,$error)) return false;

    $logupdates = entEventLoggingEnabled($ent);
    foreach($objs as $obj)
    {
        if (!array_key_exists("id",$obj)) $obj["id"] = entCreateObjID($ent);
        $objscurrent[$obj["id"]] = $obj;
        if ($logupdates) entLogUpdates($ent,$obj);
    }

    $filename = getDataFile_singlejson($ent);

    if (array_key_exists("aeskey",$ent)) 
    {
        $aeskey = $ent["aeskey"];
        if (!ozsaveencryptedjson($aeskey,$filename,$objscurrent,$error))
        {
            $error = "Could not save encrypted object data. $error";
            return false;
        }
    } else
    {
        if (!ozsavejson($filename,$objscurrent,$error))
        {
            $error = "Could not save object data. $error";
            return false;
        }
    }
	return true;
}


function entSaveObj_singlejson($ent,$obj,&$error)
{
    return entSaveObjs_singlejson($ent,array($obj),$error);
}

// ******************************************************
// Load object
// ******************************************************

function entLoadOrCreateObj_singlejson($ent,$objid,&$obj,&$error)
{
    if (entLoadObj_singlejson($ent,$objid,$obj,$error)) return true;

    if (!isEmpty($objid)) $obj["id"] = $objid;
    return entCreateObjAttrs($ent,$obj,$error);
}

function entLoadObj_singlejson($ent,$objid,&$obj,&$error)
{
    if (!entLoadObjs_singlejson_noconvert($ent,$objs,$error))
    {
        $error = "Object does not exist";
        return false;
    }

    if (!array_key_exists($objid,$objs))
    {
        $error = "Object does not exist";
        return false;
    }

    $obj = $objs[$objid];
    return true;
}

function entLoadObjs_singlejson(&$ent,&$objs,&$error)
{
    entConvertFromDefault_singlejson($ent,$filename);
    return entLoadObjs_singlejson_noconvert($ent,$objs,$error);
}

function entLoadObjs_singlejson_noconvert(&$ent,&$objs,&$error)
{    
    $error = "";
    $filename = getDataFile_singlejson($ent);

    if (!file_exists($filename))
    {
        $objs=[];
        return true;
    }

    if (array_key_exists("aeskey",$ent)) 
    {
        $aeskey = $ent["aeskey"];
        if (!ozloadencryptedjson($aeskey,$filename,$objs,$error))
        {
            $error = "Could not load encrypted object data. $error";
            return false;
        }
    } else
    {
        if (!ozloadjson($filename,$objs,$error))
        {
            $error = "Could not load object data. $error";
            return false;
        }
    }

    return true;
}

function entCount_singlejson(&$ent)
{
    if (!entLoadObjs_singlejson_noconvert($ent,$objs,$error))
    {
        return -1;
    }
    return count($objs);
}

// ******************************************************
// Delete object
// ******************************************************

function entDeleteObj_singlejson($ent,$objid,&$error)
{
    entLoadObjs_singlejson_noconvert($ent,$objs,$error);
    if (!array_key_exists($objid,$objs)) return true;
    unset($objs[$objid]);
    entClear_singlejson($ent,$errorLog);
    return entSaveObjs_singlejson($ent,$objs,$error);
}

function entClear_singlejson($ent,&$error)
{
    $error = "";
    $filename = getDataFile_singlejson($ent);
    if (!file_exists($filename)) return true;
    unlink($filename);
    return true;
}

// ******************************************************
// Convert from default
// ******************************************************

function entConvertFromDefault_singlejson($ent,&$filename)
{
    $filename = getDataFile_singlejson($ent);
    if (file_exists($filename)) return;
    global $datadir;
    $dir = $datadir.$ent["dir"];
    if (!is_dir($dir)) return;
    if (!entLoadObjs_default($ent,$objs,$error)) return;
    entClear_default($ent,$error);
    entSaveObjs_singlejson($ent,$objs,$error);
}

?>