<?php
// ******************************************************
// Multi json file store engine. To use:4
// $ent["storeengine"] = "default";
// ******************************************************


function entGetStoreEngine($ent)
{
    return arrget("storeengine",$ent,"default");
}

// ******************************************************
// Save object
// ******************************************************

function entSaveObjs_default($ent,$objs,&$error)
{
    foreach($objs as $obj)
    {
        if (!entSaveObj_default($ent,$obj,$error)) return false;
    }
    return true;
}


function entSaveObj_default($ent,&$obj,&$error)
{
    if (!isset($obj["id"]) || isEmpty($obj["id"])) $obj["id"] = entCreateObjID($ent);

    $dir = entGetObjDir($ent,$obj["id"]);
    if (!ozmkdir($dir,$error))
    {
        $error = "Could not save object. $error";
        return false;
    }
    $filename = ozpathcombine($dir,entGetDataFileName($ent));
    
    if (entEventLoggingEnabled($ent))
    {
        entLogUpdates($ent,$obj);
    }

    if (array_key_exists("aeskey",$ent)) 
    {
        $aeskey = $ent["aeskey"];
        if (!ozsaveencryptedjson($aeskey,$filename,$obj,$error))
        {
            $error = "Could not save encrypted object data. $error";
            return false;
        }
    } else
    {
        if (!ozsavejson($filename,$obj,$error))
        {
            $error = "Could not save object data. $error";
            return false;
        }
    }

    return true;
}

// ******************************************************
// Load object
// ******************************************************
function entGetDataFileName($ent)
{
    $filename = (array_key_exists("datafile",$ent)) ? $ent["datafile"] : "data";
    return $filename;
}

function entLoadOrCreateObj_default($ent,$objid,&$obj,&$error)
{
    $aeskey = (array_key_exists("aeskey",$ent)) ? $ent["aeskey"] : null;
    $dir = entGetObjDir($ent,$objid);
    $filename = ozpathcombine($dir,entGetDataFileName($ent)); 

    if (!file_exists($filename))
    {
        if (!isEmpty($objid)) $obj["id"] = $objid;
        return entCreateObjAttrs($ent,$obj,$error);
    }

    $ret = ozloadencryptedjson($aeskey,$filename,$obj,$error);
    return $ret;
}


function entLoadObj_default($ent,$objid,&$obj,&$error)
{
    //Save object
    $dir = entGetObjDir($ent,$objid);
    $filename = ozpathcombine($dir,entGetDataFileName($ent)); 
    if (!file_exists($filename))
    {
        $error = "Object does not exist";
        return false;
    }

    if (array_key_exists("aeskey",$ent))
    {
        $aeskey=$ent["aeskey"];
        return ozloadencryptedjson($aeskey,$filename,$obj,$error);
    }

    $ret = ozreadjson($filename,$obj,$error);
    if (!$ret)
    {
        return false;
    }
    if (!array_key_exists("id",$obj) || $obj["id"] != $objid) {$obj["id"] = $objid;}
    return $ret;
}

function entLoadObjs_default(&$ent,&$objs,&$error)
{
    global $datadir;

    if (!array_key_exists("dir",$ent) || isEmpty($ent["dir"]))
    {
        $error = "Entity dir not defined.";
        return false;
    }

    $dir = $datadir.$ent["dir"];
    
    $objs = array();

    if (!is_dir($dir) && !ozmkdir($dir,$error))
    {
        $error = "Entity dir could not be created.";
        if (isDebug()) {$error .= " ".$error;}
        return false;
    }

    if (!ozlsdir($dir,$files,$dirs,$error))
    {
        return false;
    }

    $error = "";
    $ret = true;
    foreach($dirs as $d)
    {
        if (!entLoadObj_default($ent,$d,$obj,$loaderror)) 
        {
            if (!isEmpty($d)) { ozrmdirifempty("$dir/$d"); }
            if (isDebug()) {$error .= "While loading '$dir/$d': ".$loaderror."<BR>\r\n";}
            continue;
        }
        $objs[] = $obj;
    }

    return $ret;
}

function entCount_default(&$ent)
{
    global $datadir;
    $dir = $datadir.$ent["dir"];
    if (!ozlsdir($dir,$files,$dirs,$error))
    {
        return -1;
    }
    return count($dirs);
}

// ******************************************************
// Delete object
// ******************************************************

function entDeleteObj_default($ent,$objid,&$error)
{
    global $datadir;
    $dir = $datadir.$ent["dir"];
    if (!ismd5($objid)) 
    {
        $error = "Cannot delete item. Invalid object id.";
        return false;
    }
    
    $objdir = ozpathcombine($dir,$objid);
    if (!ozrmdir($objdir,$dir)) return false;
    return true;
}

function entClear_default($ent,&$error)
{
    global $datadir;
    $dir = $datadir.$ent["dir"];
    $error = "";
    $ret = true;
    if (!is_dir($dir)) return true;
    if (!ozlsdir($dir,$files,$dirs,$error)) return false;
    foreach($dirs as $objid)
    {
        $objdir = ozpathcombine($dir,$objid);
        if (!ozrmdir($objdir,$dir)) {
            $error .= "Could not delete $objid. Object's dir not found.<br>\r\n";
            $ret = false;
        }
    }
    return $ret;
}

?>