<?php

function entLoadObj_configphp($ent,$objid,&$obj,&$error)
{
    global $configdir;
    
    if (!array_key_exists("configfilename", $ent) || empty($ent["configfilename"])) {
        $error = "Configuration file not specified.";
        return false;
    }

    $conf = $configdir."/".$ent["configfilename"];
    

    if (!file_exists($conf)) {
        $error = "Configuration file does not exist: $conf";
        return false;
    }

    include($conf);

    $validConfig = [];
    $validConfig["id"] = $ent["name"];

    foreach ($ent["a"] as $key => $value) {
        if (isset($$key)) {
            $validConfig[$key] = $$key;
        }
    }

    if (empty($validConfig)) {
        $error = "No valid configurations found in $conf.";
        return false;
    }

    $obj = $validConfig;
    return true;
}


function entSaveObj_configphp($ent, $obj, &$error)
{
    global $configdir;
    if (!array_key_exists("configfilename", $ent) || empty($ent["configfilename"])) {
        $error = "Configuration file not specified.";
        return false;
    }

    $conf = $configdir . "/" . $ent["configfilename"];

    if (!file_exists($conf)) {
        $configContent = "<?php\n";

        foreach ($obj as $key => $value) {
            $configContent .= '$' . $key . ' = ' . var_export($value, true) . ";\n";
        }

        if (file_put_contents($conf, $configContent) === false) {
            $error = "Failed to create the configuration file: $conf";
            return false;
        }

        return true;
    }

    $configContent = file_get_contents($conf);

    if ($configContent === false) {
        $error = "Failed to read the configuration file: $conf";
        return false;
    }

    foreach ($obj as $key => $value) {
        $pattern = '/(\$' . preg_quote($key, '/') . '\s*=\s*)[^;]+;/';
        $replacement = '$' . $key . ' = ' . var_export($value, true) . ';';

        if (preg_match($pattern, $configContent)) {
            $configContent = preg_replace($pattern, $replacement, $configContent);
        }
    }

    if (file_put_contents($conf, $configContent) === false) {
        $error = "Failed to write the updated configuration back to the file: $conf";
        return false;
    }

    return true;
}


function entLoadOrCreateObj_configphp($ent,$objid,&$obj,&$error)
{
    global $configdir;
    
    if (!array_key_exists("configfilename", $ent) || empty($ent["configfilename"])) {
        $error = "Configuration file not specified.";
        return false;
    }

    $conf = $configdir."/".$ent["configfilename"];
    

    if (!file_exists($conf)) {
        if (!isEmpty($objid)) $obj["id"] = $objid;
        return entCreateObjAttrs($ent,$obj,$error);
    }

    $ret = entLoadObj_configphp($ent,"",$obj,$error);
    return $ret;
}


function entLoadObjs_configphp(&$ent,&$objs,&$error)
{
    $objs = array();
    if(!entLoadObj_configphp($ent,"",$obj,$error)) return [];
    $objs[] = $obj;
    return $objs;
}