<?php
// ******************************************************
// Entity / Form generation
// ******************************************************

// ******************************************************
// Form processing
// ******************************************************

function entProcessForm_LoadAction($ent)
{
    $formname = $ent["name"];
    $formaction = "formaction_$formname";
    global $$formaction;
    loadReqParams($formaction);
    $action = $$formaction;
    return $action;
}

function entProcessForm($ent,&$obj,&$error)
{
    $action = entProcessForm_LoadAction($ent);
    
    if ($action!="create" && $action!="update" && $action !="delete") return true;

    $tn = $ent["name"]."_selectedtype";
    if (array_key_exists($tn,$_REQUEST)) $typeCreatorFunc = $_REQUEST[$tn];
    
    if (($action=="create" || $action=="update") && 
	    isset($typeCreatorFunc) &&
        !entTypeSelected($ent,$obj,$typeCreatorFunc))
    {
        $error = "Cannot process form. Type selection error.";
        return false;
    }

    if ($action=="create")
    {
        return entProcessFormCreate($ent,$obj,$error);
    } 

    if ($action=="update")
    {
        return entProcessFormUpdate($ent,$obj,$error);
    }
    
    if ($action=="delete")
    {
        return entProcessFormDelete($ent,$obj,$error);
    }

    return true;
}

function entProcessFormCreate($ent,&$obj,&$error)
{
    $objid=entCreateObjID($ent,date("ymdhis"));
    if (!entUpdateFromInput($ent,$objid,$obj,$error)) return false;
    return entExecuteEventHandlerOnCreated($ent,$obj,$error);
}

function entProcessFormUpdate($ent,&$obj,&$error)
{
    global $objid;
    loadReqParams("objid");
    
    if (!entUpdateFromInput($ent,$objid,$obj,$error)) return false;
    return entExecuteEventHandlerOnUpdated($ent,$obj,$error);
}

function entUpdateFromInput($ent,$objid,&$obj,&$error)
{
    if (!entLoadObj($ent,$objid,$obj,$error)) $obj = array();
    $obj["id"] = $objid;
    $attrs = $ent["a"];
    $ret = true;
    $ename = $ent["name"];
    foreach($attrs as $a)
    {
        if ((array_key_exists("form",$a) && !$a["form"])) continue;
        $funcname = "attr".ucfirst($a["type"])."ProcessInput";
        if (!function_exists($funcname))
            $funcname = "attrProcessInput";
        if (!$funcname($ent,$a,$obj,$error)) 
        {
            $ret = false;
            $aname = $a["name"];
            $obj[$aname."_error"] = $error;
        }
    }
   
    if (!entSaveObj($ent,$obj,$error)) return false;
   
    return true;
}


function entProcessFormDelete($ent,&$obj,&$error)
{
    global $objid;
    loadReqParams("objid");
    if (isEmpty($objid)) return true;

    if (ozstrcontains($objid,","))
    {
        $ret = true;
        $errors = [];
        $objdis = explode(",",$objid);
        foreach($objdis as $objid)
        {
            $objdelret = entDeleteObj($ent,$objid,$error);
            $ret = $ret & $objdelret;
            if (!$objdelret)
            {
                $errors[] = $error;
            }
        }
        if (!$ret) $error = implode(";",$errors);
        return $ret;
    }

    return entDeleteObj($ent,$objid,$error);
}

// ******************************************************
// Display form
// ******************************************************

function entOrderAttributesIntoTabs(&$ent,&$tabs)
{
    $tabs = array();
    $attrs = $ent["a"];
    $attrsgrouped = array();
    foreach($attrs as $a)
    {
        if ((array_key_exists("form",$a) && !$a["form"])) continue;
        if (!array_key_exists("groupbox",$a) || isEmpty($a["groupbox"])) $a["groupbox"] = "none";
        if (!array_key_exists("tabpage",$a) || isEmpty($a["tabpage"])) $a["tabpage"] = "general";
        if (!array_key_exists("order",$a) || isEmpty($a["order"])) $a["order"] = 0;
        $attrsgrouped[] = $a;
    }

    usort($attrsgrouped, function($a, $b) {  if ($a["order"] == $b["order"]) return 0; if ($a["order"] > $b["order"]) {return 1;} else {return -1;} });

    foreach($attrsgrouped as $a)
    {
        $tabname = $a["tabpage"];
        $groupboxname = $a["groupbox"];
        $tabs[$tabname][$groupboxname][] = $a;
    }
}

function entDisplayFormGroupboxStart($title,$open=true)
{
    $hidden = !$open;
    if ($title=="none") 
    {
        $hidden = false;
    }
    $id = md5($title);
    $idgroupbox = $id."_GroupBox";
    $idlabel = $id."_Label";
    $contentdisplaystyle = ($hidden)?"none":"block";
    $legenddisplaystyle = ($hidden)?"GroupBoxHide":"GroupBoxShow";
    $groupboxicon = ($hidden)?"<img onclick='GroupBoxHideContent(event);' id='".$id."_Label_img' src='/ozekiservices/system/attachments/1/img/grpboxopen.svg' class='GroupBoxIcon' />" : "";

    if ($title=="none") 
    {
        $stylefieldset = "margin-top:20px";
        $stylediv = "margin-top:0px";
        $legend="";
    } else 
    {
        $stylefieldset = "";
        $stylediv = "margin-top:-10px";
        $legend =<<<LEGEND
        <legend class="mb-2">
            <label id="$idlabel" class="GroupBoxTitle" onclick="GroupBoxHideContent(event, true);" style="text-shadow: 0px 2px white">$title</label>
            $groupboxicon
        </legend>
LEGEND;
    }

    $grpboxstart =<<<GRPBOXSTART
    <fieldset id="$idgroupbox" class="$legenddisplaystyle ms-0 me-0 ps-2 pe-2 mt-1 mb-3" style="$stylefieldset">
    $legend
    <div style="display:$contentdisplaystyle; $stylediv">
GRPBOXSTART;
    return $grpboxstart;
}

function entDisplayFormGroupboxEnd()
{
    $grpboxend =<<<GRPBOXEND
    </div>
    </fieldset>
GRPBOXEND;
    return $grpboxend;
}

function entDisplayFormAttr($ent,$attr,$obj)
{
    $funcname = "attr".ucfirst($attr["type"])."Input";
    if (!function_exists($funcname)) return "";
    return $funcname($ent,$attr,$obj);
}

function entIsGroupboxOpen($ent,$obj,$groupboxname)
{
    if (array_key_exists("groupboxopenfunc",$ent)) 
    {
        $funcname = $ent["groupboxopenfunc"];
        if (function_exists($funcname)) 
        {
            return $funcname($ent,$obj,$groupboxname);
        }
    }

    if (!array_key_exists("groupbox",$ent)) return true;
    if (!array_key_exists($groupboxname,$ent["groupbox"])) return true;
    if (!array_key_exists("open",$ent["groupbox"][$groupboxname])) return true;
    return $ent["groupbox"][$groupboxname]["open"];
}

function entDisplayFormTabStart($ent,$tabname)
{
    if (array_key_exists("usetabs",$ent) && !$ent["usetabs"]) return "";
    return  card($tabname);;
}

function entDisplayFormTabEnd($ent,$tabname)
{
    if (array_key_exists("usetabs",$ent) && !$ent["usetabs"]) return "";
    return cardend();
}

//**************************************************************
// Display form inputs
//**************************************************************
function entDisplayGroupBox($ent,$obj,$usegroupboxes,$groupboxname,$attrs,&$formbodytop,&$formbody,&$submitbuttonfound)
{
    $visible = false;
    $content = "";
    $formbody = "";
    $formbodytop = "";
    foreach($attrs as $a)
    {
        if ($a["type"]=="submit") $submitbuttonfound = true;
        $content .=  entDisplayFormAttr($ent,$a,$obj);

        if (($a["type"] != "hidden") && 
           ((!array_key_exists("visible",$a) || $a["visible"]==true)))
        {
            $visible=true;
        }
    }

    if (isEmpty($content)) 
    {
        return;
    }

    if (!$visible) 
    {
        $formbodytop = $content;
        return;
    }

    if (!$usegroupboxes) 
    {
        $formbody = $content;
        return;
    }
    
    $groupboxopen = entIsGroupboxOpen($ent,$obj,$groupboxname);
    $formbody .= entDisplayFormGroupboxStart($groupboxname,$groupboxopen);
    $formbody .= $content;
    $formbody .= entDisplayFormGroupboxEnd();
}

function entDisplayFormInputs($ent,$obj)
{
    entOrderAttributesIntoTabs($ent,$tabs);
    $formbodytop = "";
    $formbody = "";
    $submitbuttonfound = false;
    $usegroupboxes = (!array_key_exists("usegroupboxes",$ent) || $ent["usegroupboxes"]==true) ? true : false;
    foreach($tabs as $tabname=>$groupboxes)
    {
        $formbody .= entDisplayFormTabStart($ent,$tabname);

        foreach ($groupboxes as $groupboxname=>$attrs)
        {
            entDisplayGroupBox($ent,$obj,$usegroupboxes,$groupboxname,$attrs,$gbformbodytop,$gbformbody,$submitbuttonfound);
            $formbodytop .= $gbformbodytop;
            $formbody .= $gbformbody;
        }
        
        $formbody .= entDisplayFormTabEnd($ent,$tabname);
    }

    if (!$submitbuttonfound) 
    {
        $a = attrSubmit();
        $formbody .= attrSubmitInput($ent,$a,$obj);
    }
    return $formbodytop.$formbody;
}

//**************************************************************
// Display form header and footer
//**************************************************************

function entDisplayFormHeader($ent,$obj=null)
{
    global $owpname;

    $enctype = (array_key_exists("enctype",$ent) && !isEmpty($ent["enctype"])) ? 'enctype="'.$ent["enctype"].'"'  : "";
    $formname = $ent["name"];
    $inputid = ($obj==null) ? "" : "<input type='hidden' name='objid' value='".$obj["id"]."'>";
    
    $formextra = (array_key_exists("formextra",$ent) && !isEmpty($ent["formextra"])) ?  $ent["formextra"] : "";
    $linkextra = getAutoLinkExtra($ent);
    $formtop = array_key_exists("descriptionformtop",$ent) ? "<div>".$ent["descriptionformtop"]."</div>" : "";
    $width = entGetWidth($ent);

    $target = (array_key_exists("formtarget",$ent)) ? $ent["formtarget"] : $owpname;

    $formheader =<<<FORMHEAD
    <form action="index.php?owpn=$target$linkextra" method="post" $enctype class="ms-0">
    $inputid
    $formextra
    <div class="container ms-0 justify-content-left p-0" style='max-width:$width;'>
FORMHEAD;

    return $formtop.$formheader;
}

function entDisplayFormAction($ent,$action)
{
    $inputnameaction = "formaction_".$ent["name"];
    return "<INPUT type='hidden' name='$inputnameaction' value='$action'>\r\n";
}

function entDisplayObjectType($originalent,$ent)
{
    if (!array_key_exists("typecreator",$ent["a"])) return "";
   
    $inputnametype = $originalent["name"]."_selectedtype";
    $typecreator = $ent["a"]["typecreator"]["value"];
    return "<INPUT type='hidden' name='$inputnametype' value='$typecreator'>\r\n";
}

function entDisplayFormFooter()
{
    $formfooter =<<<FORMFOOT
    </div>
    </form>
FORMFOOT;

    return $formfooter;
}

//**************************************************************
// Display form only
//**************************************************************

function entDisplayForm($ent,$obj=null)
{  
    //Save original type
    $originalent = $ent;

    //Select type
    if (!entTypeSelected($ent,$obj))
    {
        return entDisplayTypeSelector($ent);
    }

    //Decide action
    $action = ($obj==null) ? "create" : "update";

    //Create obj
    if ($action=="create") entCreateObjAttrs($ent,$obj,$error);

    //Form header
    $formheader = entDisplayFormHeader($ent,$obj);

    //Form action 
    $formaction = entDisplayFormAction($originalent,$action);

    //Form object type
    $formtype = entDisplayObjectType($originalent,$ent);

    //Form body
    $formbody = entDisplayFormInputs($ent,$obj);

    //Form footer
    $formfooter = entDisplayFormFooter();

    $ret = $formheader.$formaction.$formtype.$formbody.$formfooter;
    return $ret;
}

//**************************************************************
// Display and process form
//**************************************************************

function entDisplayAndProcessForm($ent,&$action,$visible,&$obj)
{
    $action="create";

    //Load object to edit
    $obj = null;
    $formaction = "formaction_".$ent["name"];
    global $$formaction,$objid;
    loadReqParams($formaction,"objid");
    if ($$formaction=="edit")
    {
        $action = "update";
        if (!entLoadObj($ent,$objid,$obj,$error))
        {
            $obj = null;
            $action = "create";
        }
    
        $visible = true;
    }  
    if  ($$formaction=="new")
    {
        $obj = null;
        $visible = true;
    }

    //Return if the form is not visible
    if (!$visible) return "";

    $ret = entDisplayForm($ent,$obj);
    return $ret;
}

//**************************************************************
// Display form card
//**************************************************************

function entDisplayFormCard($ent,$visible=false)
{
    global $owpname;
    $form = entDisplayAndProcessForm($ent,$action,$visible,$obj);
    if ($form == "") return "";

    //Hide the list if a form is oipen
    $tableactionname = "tableaction_".$ent["name"];
    global $$tableactionname;
    $$tableactionname = "hide";

    //Setup the card title
    if ($action=="update")
    {
        $cardtitle = "Edit ".$ent["title"];
    } 
    else
    {
        $title = (array_key_exists("lctitle",$ent)) ? $ent["lctitle"] : lcfirst($ent["title"]);
        $cardtitle = "Create a new ".$title;
    }

    //Cancel button
    $linkextra = getLinkExt($ent);
    $url="index.php?owpn=$owpname&$linkextra".nocache();
    $buttoncancel = "<a href='$url'><button class='btn btn-secondary'>Cancel</button></a>";

    //Display the card
    $ret = "<div style='max-width:".entGetWidth($ent).";'>";
    $ret .= card($cardtitle,$buttoncancel);
    $ret .= $form;
    $ret .= cardend();
    $ret .= "</div>";

    //Debug information
    if (isDebug() && is_array($obj))
    {
        $ret .= card("Debug");
        ob_start();
        var_dump($obj);
        $objdebug = ob_get_contents();
        ob_end_clean();
        $ret .= $objdebug;
        $ret .= cardend();
    }

    return $ret;
}

?>
