<?php
include_once("$sysdir/form/filter/evalFuncs.php");
include_once("$sysdir/form/filter/filterComboBox.php");
include_once("$sysdir/form/filter/filterTextBox.php");

//******************************************************
// Filtering 
// 
// Register a filter function:
// $ent["filterfunc"][] = "filterCompetitors";
//
// Example filter function:
// function filterCompetitors($ent,$objs)
// {
//    global $projectid;
//    $ret = [];
//    foreach($objs as $obj)
//    {
//        if ($obj["projectid"]!=$projectid) continue;
//        $ret[] = $obj;
//    }
//    return $ret;
// }
//******************************************************

function entFilterObjects($ent,$objs)
{
    if (array_key_exists("filterfunc",$ent))
    {
        foreach($ent["filterfunc"] as $ff)
        {
            $objs = $ff($ent,$objs);
        }
    }
    return $objs;
}

//******************************************************
// Fitler form
// 
// Register a filter form:
// $ent["filterform"] = true;
//
// $ent["a"]["name"]["filterform"] = "filterTextBox";
// $ent["a"]["name"]["filterform"] = "filterComboBox";
//
// $ent["a"]["name"]["filtereval"] = "evalExactMatch";
// $ent["a"]["name"]["filtereval"] = "evalPartialMatch";
// $ent["a"]["name"]["filtereval"] = "evalRegexMatch";
//
//******************************************************
function entFilterObjAllowedByAttr($ent,$attr,$obj)
{
    global $sysdir;
    //Is this attr filterable
    if (!array_key_exists("filterform",$attr) || isEmpty($attr["filterform"])) return true;

    //Is the filter value present in the request
    $inputname = "filter_".$ent["name"]."_".$attr["name"];
    global $$inputname;
    loadSessionReqParams($inputname);
    if (isEmpty($$inputname)) return true;

    //Is the filter value not empty
    //$filtervalue = $_REQUEST[$inputname];
    $filtervalue = $$inputname;
    //var_dump($filtervalue);
    if (isEmpty($filtervalue)) return true;
   
    //Is the filter value matching function present
    $evalFunc = (array_key_exists("filtereval",$attr)) ? $attr["filtereval"] : "evalExactMatch";
    if (empty($evalFunc)) return true;
    if (!function_exists($evalFunc)) return true;

    //Is the filter matching the object
    return $evalFunc($ent,$attr,$obj,$filtervalue);
}

function entFilterObjAllowed($ent,$attrs,$obj)
{
    foreach($attrs as $attr)
    {
        if (!entFilterObjAllowedByAttr($ent,$attr,$obj)) return false;
    }
    return true;
}

function entEvaluateFilterForm(&$ent,$objs)
{
    $objsret = [];
    $attrs = $ent["a"];

    foreach($objs as $obj) 
    {
        if (entFilterObjAllowed($ent,$attrs,$obj)) $objsret[] = $obj;
    }

    return $objsret;
}


function entDisplayFilterForm(&$ent)
{
    global $sysdir,$owpname;
    if (!array_key_exists("filterform",$ent)) return "";
    if ($ent["filterform"]==false) return;

    //Load objects without filter form filter
    if (array_key_exists("filterfunc",$ent) && array_key_exists("entEvaluateFilterForm",$ent["filterfunc"])) unset($ent["filterfunc"]["entEvaluateFilterForm"]);
    entLoadObjs($ent,$objs,$error);
    $ent["filterfunc"][] = "entEvaluateFilterForm";

    //Create inputs
    $inputs = [];
    $filterattrs = [];
    $attrs = $ent["a"];
    usort($attrs,"entSortAttrs");
    foreach($attrs as $attr)
    {
        if (!array_key_exists("filterform",$attr) || isEmpty($attr["filterform"])) continue;
        $filterForm = $attr["filterform"];
        $inputs[] = $filterForm($ent,$attr,$objs);
    }

    //Display
    $target = (array_key_exists("formtarget",$ent)) ? $ent["formtarget"] : $owpname;
    $formextra = (array_key_exists("formextra",$ent) && !isEmpty($ent["formextra"])) ?  $ent["formextra"] : "";
    $linkextra = getAutoLinkExtra($ent);
    $width = entGetWidth($ent);
    $inputfields = implode("\r\n",$inputs);

    $ret = <<<FILTERFORM
    <form action="index.php?owpn=$target$linkextra" method="get" class="ms-0">
        <input type='hidden' name='owpn' value='$target'>
        $formextra
        <div class="container ms-0 justify-content-left p-0" style='max-width:$width;'>
        $inputfields
        <button name='Filter' class='btn btn-secondary'>Fiter</button>
        </div>
    </form>

FILTERFORM;
    return $ret;
}

//**************************************************************
// Display filter form card
//**************************************************************

function entDisplayFilterFormCard(&$ent)
{
    $cardtitle = "Filter";
    $form = entDisplayFilterForm($ent);

    $ret = "<div style='max-width:".entGetWidth($ent).";'>";
    $ret .= card($cardtitle);
    $ret .= $form;
    $ret .= cardend();
    $ret .= "</div>";
    return $ret;
}

// ******************************************************
// Ordering
// ******************************************************

function entSortAttrs($a,$b)
{
    $ordera = (array_key_exists("order",$a)) ? $a["order"] : 0;
    $orderb = (array_key_exists("order",$a)) ? $a["order"] : 0;
    if ($ordera < $orderb) return -1;
    if ($ordera = $orderb) return 0;
    return 1;
}

function entSortObjects($ent,&$objs)
{
    global $debugsort,$orderbymode;
    $debugsort = false;
    if (array_key_exists("orderbymode",$ent))
    {
        $orderbymode = $ent["orderbymode"];
    } else 
    {
        $orderbymode = "string";
    }

    if (!array_key_exists("orderbyfunc",$ent) && array_key_exists("orderby",$ent))
    {
        global $orderby;
        $orderby = $ent["orderby"];
        //var_dump($orderby);

        $reverse = false;
        if (strpos($orderby," desc"))
        {
            $orderby = str_replace(" desc","",$orderby);
            $reverse = true;
        }

        if (strpos($orderby," asc"))
        {
            $orderby = str_replace(" asc","",$orderby);
            $reverse = false;
        }

        usort($objs, 
          function($a, $b) { 
            global $orderby,$debugsort,$orderbymode;
            $av = array_key_exists($orderby,$a) ? $a[$orderby] : 0;
            $bv = array_key_exists($orderby,$b) ? $b[$orderby] : 0;
            if (is_null($av)) $av=0;
            if (is_null($bv)) $bv=0;

            if ($orderbymode=="string")
            {
                return strcmp($av,$bv);
            }

            if ($debugsort) echo "Comparing: $av,$bv;";
            if ($av == $bv) 
            {
                if ($debugsort) echo "Equal<br>";
                return 0; 
            }
            if ($av > $bv) 
            {
                if ($debugsort) echo "Greater: $av<br>";
                return 1;
            } 
            else 
            {
                if ($debugsort) echo "Greater: $bv<br>";
                return -1;
            } 
          }
        );

        if ($reverse) $objs = array_reverse($objs);
    }

    if (array_key_exists("orderbyfunc",$ent))
    {
        $func = $ent["orderbyfunc"];
        usort($objs,$func);
    }
}

?>