<?php
// ******************************************************
// Entity / Table generation
// ******************************************************

function addStamps(&$ent)
{
    $n = "createdby";
    $ent["a"][$n] = attrUserstamp($n,"Created by");
    $ent["a"][$n]["list"] = false;
    $ent["a"][$n]["form"] = true;

    $n = "createdate";
    $ent["a"][$n] = attrCreatestamp($n,"Create date");
    $ent["a"][$n]["list"] = false;
    $ent["a"][$n]["form"] = true;

    $n = "modifydate";
    $ent["a"][$n] = attrTimestamp($n,"Modify date");
    $ent["a"][$n]["list"] = false;
    $ent["a"][$n]["form"] = true;

    $n = "createip";
    $ent["a"][$n] = attrIpstamp($n,"Created from");
    $ent["a"][$n]["list"] = false;
    $ent["a"][$n]["form"] = true;
}

function addAddress(&$ent,&$order, $groupbox="")
{
    $ent["a"]["street"] = attrText("street","Street address");
    $ent["a"]["street"]["placeholder"] = "Example: 123 Newburry Drive";
    $ent["a"]["street"]["below"] = "Please provide the street address";
    $ent["a"]["street"]["groupbox"] = $groupbox;
    $ent["a"]["street"]["order"] = $order++;

    $ent["a"]["locality"] = attrText("locality","City / Locality");
    $ent["a"]["locality"]["placeholder"] = "Example: Gainesville";
    $ent["a"]["locality"]["below"] = "Please provide the city";
    $ent["a"]["locality"]["groupbox"] = $groupbox;
    $ent["a"]["locality"]["order"] = $order++;

    $ent["a"]["region"] = attrText("region","Region / State / County");
    $ent["a"]["region"]["placeholder"] = "Example: Florida";
    $ent["a"]["region"]["below"] = "Please provide the region";
    $ent["a"]["region"]["groupbox"] = $groupbox;
    $ent["a"]["region"]["order"] = $order++;

    $ent["a"]["country"] = attrCombocountry("country","Country");
    $ent["a"]["country"]["below"] = "Please select the country";
    $ent["a"]["country"]["groupbox"] = $groupbox;
    $ent["a"]["country"]["order"] = $order++;

    $ent["a"]["postalcode"] = attrText("postalcode","Postal code");
    $ent["a"]["postalcode"]["placeholder"] = "FL12345";
    $ent["a"]["postalcode"]["below"] = "Please provide the postal code";
    $ent["a"]["postalcode"]["style"] = "max-width:150px";
    $ent["a"]["postalcode"]["groupbox"] = $groupbox;
    $ent["a"]["postalcode"]["order"] = $order++;
}

// ******************************************************
// Entity / Service
// ******************************************************

function onServiceEntityUpdated($ent,&$obj,&$error)
{
    $obj["serviceid"] = $ent["serviceid"];
    if (!entSaveObj($ent,$obj,$error)) return false;
    return true;
}

//**************************************************************
// Event handler
//**************************************************************
function onServiceEntityConstructed($ent,&$obj,&$error)
{
    $serviceid = $ent["serviceid"];
    return true;
}

function addServiceEntityEvents(&$ent)
{
    $ent["onupdated"][] = "onServiceEntityUpdated";
    $ent["oncreated"][] = "onServiceEntityUpdated";
    $ent["onconstructed"][] = "onServiceEntityConstructed";
}

?>