<?php
// ******************************************************
// Entity / Event logging
// 
// Usage:
// 1.) Set the flag for the entity
//     $ent["logupdates"] = true;
// 2.) Set the flag for attributes of interest:
//     $ent["a"][$n]["logupdates"] = true;
// 
// ******************************************************

function entEventLoggingEnabled($ent)
{
    if (!array_key_exists("logupdates",$ent)) return false;
    return $ent["logupdates"];
}

//*******************************************************
// Event logging / write log
//*******************************************************
function entSaveLogEntry($ent,$objid,$msg)
{
    global $myuserid;
    $logentry = mysqldate()." ".$myuserid." ".$msg;
    $logfile = entLogFile($ent,$objid);
    ozappendfile($logfile,$logentry."\r\n",$error);
}

function entLogUpdates($ent,$obj)
{
    $event = "";
    if (!entLoadObj($ent,$obj["id"],$origobj,$error))
    {
        $event = "Created";
        entSaveLogEntry($ent,$obj["id"],$event);
        return;
    }

    foreach($ent["a"] as $attr)
    {
        if (!array_key_exists("logupdates",$attr)) continue;
        if (!$attr["logupdates"]) continue;
        $attrname = $attr["name"];
        $oldvalue = entDisplayAttrStoredValue($ent,$attr,$origobj);
        $oldvalue = (!isEmpty($oldvalue)) ? ozsingleline(strip_tags($oldvalue)) : "";

        $newvalue = entDisplayAttrStoredValue($ent,$attr,$obj);
        $newvalue = (!isEmpty($newvalue)) ? ozsingleline(strip_tags($newvalue)) : "";

        if ($oldvalue==$newvalue) continue;
        $label = entDisplayTableHeaderLabel($attr);
        $event = "$label changed from '".ozfrontwithdots($oldvalue,255)."' to '".ozfrontwithdots($newvalue,255)."'";
        entSaveLogEntry($ent,$obj["id"],$event);
    }
}

//*******************************************************
// Event logging / logfile
//*******************************************************

function entLogFile($ent,$objid)
{
    global $datadir;
    $logfile = $datadir.$ent["dir"]."/".$objid."/log.txt";
    return $logfile;  
}

//*******************************************************
// Event logging / display
//*******************************************************

function entDisplayLogFile($ent,$objid,&$loglines)
{
    $f = entLogFile($ent,$objid);
    if (!file_exists($f)) 
    {
        $loglines = "";
        return false;
    }

    if (!ozreadlines($f,$lines,$error))
    {
        $loglines = "";
        return false;
    }

    $lines = array_reverse($lines);

    $loglines = "";
    foreach($lines as $line)
    {
        list($date,$time,$user,$message) = explode(" ",$line,4);
        $user = GetName($user);
        $loglines.= "$date $time <b>$user:</b> $message<br>";
    }

    return true;
}
?>
