<?php

function entAddDragDrop($ent,$obj)
{
    $objid = $obj["id"];
    $dragstart = array_key_exists("ondragstart",$ent) ? " ondragstart='".$ent["ondragstart"]."(event,\"$objid\")' " : "";
    $dragable = ($dragstart!="") ? " draggable='true' ":"";
    $dragover = array_key_exists("ondragover",$ent) ? " ondragover='".$ent["ondragover"]."(event,\"$objid\")' " : "";
    $dragdrop = array_key_exists("ondragdrop",$ent) ? " ondrop='".$ent["ondragdrop"]."(event,\"$objid\")' " : "";
    return $dragable.$dragstart.$dragover.$dragdrop;
}

// **********************************************************************************
// Make an object dragabble
// Usage:
//
// echo displayDragStartScript(&$ent)
// **********************************************************************************

function displayDragStartScript(&$ent)
{
    $entName = $ent["name"];

    $ent["ondragstart"] = "drag$entName";

    $script = <<<DRAGDROPSCRIPT
    <script>
    function drag$entName(ev,objid) 
    {
        ev.dataTransfer.setData("text", ev.target.id);
    }

    </script>
DRAGDROPSCRIPT;

    return $script;
}


// **********************************************************************************
// Make an object the drop target
// Usage:
//
// $dropurl = "index.php?owpn=$owpn&draggedid=[DRAGGED_ID]&droppedonid=[DROPPEDON_ID]";
// echo displayDragDropScript($ent,$dropurl);
// **********************************************************************************

function displayDragDropScript(&$ent,$dropurl)
{
    $entName = $ent["name"];
    $ent["ondragover"] = "allowDrop$entName";
    $ent["ondragdrop"] = "drop$entName";

    $script = <<<DRAGDROPSCRIPT
    <script>
    function allowDrop$entName(ev,objid) 
    {
        ev.preventDefault();
    }
 
    function drop$entName(ev,dropon_objid) 
    {
        var dropurl = "$dropurl";
        ev.preventDefault();
        var dragged_objid = ev.dataTransfer.getData("text");
        dropurl = dropurl.replace("[DRAGGED_ID]",dragged_objid);
        dropurl = dropurl.replace("[DROPPEDON_ID]",dropon_objid);
        window.location = dropurl;
        //alert(dropurl);
    }
    </script>
DRAGDROPSCRIPT;

    return $script;
}


?>