<?php
// ******************************************************
// Entity
// -----------------------------------------------------
// Popular functions:
// -----------------------------------------------------
// function entDisplayForm($ent,$obj=null)
// function entDisplayTable(&$ent)
// function entAdmin($ent)
// function entCount(&$ent)
// function entCreateObj($ent,&$obj,&$error)
// function entLoadObjs(&$ent,&$objs,&$error)
// function entLoadObj($ent,$objid,&$obj,&$error)
// function entSaveObj($ent,$obj,&$error)
// function entDeleteObj($ent,$objid,&$error)
// function entClear($ent,&$errorLog)
// ******************************************************

include_once("$sysdir/form/ent/_ent_filterform.php");
include_once("$sysdir/form/ent/_ent_form.php");
include_once("$sysdir/form/ent/_ent_table.php");
include_once("$sysdir/form/ent/_ent_store_default.php");
include_once("$sysdir/form/ent/_ent_store_configphp.php");

// ******************************************************
// Construct
// ******************************************************

function ent($name)
{
    $ent = array();
    $ent["name"] = $name;
    return $ent;
}

function entAddAttr(&$ent,&$attr,$groupbox="",$tabpage="")
{
    if (!is_array($ent)) 
    {
        global $debug;
        if (!$debug) return;
        echo "Cannot add attribute to invalid entity;"; exit;
    }

    if (!array_key_exists("a",$ent) || !is_array($ent["a"])) $ent["a"] = array();

    if (!isEmpty($groupbox)) $attr["groupbox"] = $groupbox;
    if (!isEmpty($tabpage)) $attr["tabpage"] = $tabpage;

    $attr["order"] = is_array($ent["a"]) ? count($ent["a"])+1 : 1;

    $attrname = $attr["name"];
    $ent["a"][$attrname] = $attr;

    $funcname = "attr".$attr["type"]."AddedToEnt";
    if (function_exists($funcname))
    {
        $funcname($ent);
    }

    return $attr;
}

// ******************************************************
// Properties
// ******************************************************

function entIsSingleton($ent)
{
    if ($ent==null) return false;
    if (array_key_exists("singleton",$ent) && $ent["singleton"]) return true;
    return false;
}

function entGetObjDir($ent,$objid)
{
    global $datadir;
    $dir = $datadir.$ent["dir"];
    if (entIsSingleton($ent)) return $dir;
    $dir = ozpathcombine($dir,$objid); 
    return $dir;
}

// ******************************************************
// Event handlers
// ******************************************************
function entEventHandlerExists($handler,$ent)
{
    if (!array_key_exists($handler,$ent)) return false;
    if (!is_array($ent[$handler])) return false;
    return true;
}

function entExecuteEventHandler($handler,&$ent,&$obj,&$error)
{
    if (!entEventHandlerExists($handler,$ent)) return true;
    $ret = false;
    $errors = [];
    foreach($ent[$handler] as $eventhandlefunc) 
    {
       if (!function_exists($eventhandlefunc)) continue;
       if ($obj!=null)
       {
            $ret |= $eventhandlefunc($ent,$obj,$errorResult);
            if (!isEmpty($errorResult))
            {
                $errors[] = $errorResult;
            }
       }
    }

    $error = (is_array($errors)) ? implode(" ",$errors) : "" ;
    
    return $ret;
}

function entExecuteEventHandlerOnUpdated(&$ent,&$obj,&$error)
{
    return entExecuteEventHandler("onupdated",$ent,$obj,$error);
}

function entExecuteEventHandlerOnDeleted(&$ent,&$obj,&$error)
{
    return entExecuteEventHandler("ondeleted",$ent,$obj,$error);
}

function entExecuteEventHandlerOnCreated(&$ent,&$obj,&$error)
{
    return entExecuteEventHandler("oncreated",$ent,$obj,$error);
}

function entExecuteEventHandlerOnConstructed(&$ent,&$obj,&$error)
{
    return entExecuteEventHandler("onconstructed",$ent,$obj,$error);
}

function entExecuteEventHandlerOnListed(&$ent,&$obj,&$error)
{
    return entExecuteEventHandler("onlisted",$ent,$obj,$error);
}
// ******************************************************
// Create object
// ******************************************************

function entCreateObjID($ent,$prefix="")
{
    $taillength = 32-strlen($prefix);
    $id = $prefix.ozrndstr($taillength);
    return $id;
}

function entCreateObj($ent,&$obj,&$error)
{
    $obj = null;
    return entCreateObjAttrs($ent,$obj,$error);
}

function entCreateObjAttrs($ent,&$obj,&$error)
{
    $objid=entCreateObjID($ent,date("ymdhis"));
    if ($obj==null) $obj = array();
    if (!array_key_exists("id",$obj) || isEmpty($obj["id"]))
    {
        $obj["id"] = $objid;
    }

    if (array_key_exists("typecreator",$ent))
    {
        $obj["typecreator"] = $ent["typecreator"];
    }

    $attrs = $ent["a"];
    $ret = true;
    foreach($attrs as $a)
    {
        if ((array_key_exists("form",$a) && !$a["form"])) continue;
        $funcname = "attr".ucfirst($a["type"])."CreateValue";
        if (!function_exists($funcname))
            $funcname = "attrCreateValue";
        if (!$funcname($ent,$a,$obj,$error)) 
        {
            $ret = false;
            $aname = $a["name"];
            $obj[$aname."_error"] = $error;
        }
    }

    if (!$ret) return false;

    if (!entExecuteEventHandlerOnConstructed($ent,$obj,$error))
    {
        $error = "OnConstucted event handler failed. $error";
        return false;
    }

    return true;
}

// ******************************************************
// Save object
// ******************************************************

function entSaveObjs($ent,$objs,&$error)
{
    if (!isset($obj["id"]) || isEmpty($obj["id"])) $obj["id"] = entCreateObjID($ent);

    $se = entGetStoreEngine($ent);
    $fn = "entSaveObjs_$se";
    return $fn($ent,$objs,$error);
}


function entSaveObj($ent,&$obj,&$error)
{
    $se = entGetStoreEngine($ent);
    $fn = "entSaveObj_$se";
    return $fn($ent,$obj,$error);
}

// ******************************************************
// Load objects
// ******************************************************
$entobjcache = array();
function entLoadObjCached($ent,$objid,&$obj,&$error)
{
    global $entobjcache;
    if (array_key_exists($objid,$entobjcache)) {$obj = $entobjcache[$objid]; return true;}
    if (!entLoadObj($ent,$objid,$obj,$error)) return false;
    $entobjcache[$objid] = $obj;
    return true;
}

function entLoadOrCreateObj($ent,$objid,&$obj,&$error)
{
    $se = entGetStoreEngine($ent);
    $fn = "entLoadOrCreateObj_$se";
    return $fn($ent,$objid,$obj,$error);
}

function entLoadObj($ent,$objid,&$obj,&$error)
{
    $se = entGetStoreEngine($ent);
    $fn = "entLoadObj_$se";
    return $fn($ent,$objid,$obj,$error);
}

function entLoadObjs(&$ent,&$objs,&$error)
{
    $se = entGetStoreEngine($ent);
    $fn = "entLoadObjs_$se";
    if (!$fn($ent,$objs,$error)) 
    {
        return false;
    }
    if ($error!="")
    {
        if (isDebug()) {echo "$error<br>";}
    }
    $objs = array_values($objs);
    $objs = entFilterObjects($ent,$objs);
    entSortObjects($ent,$objs);
    return true;
}

function entObjsToAssoc($objs)
{
    $ret = [];
    foreach($objs as $obj)
    {
        $ret[$obj["id"]]=$obj;
    }
    return $ret;
}

function entCount(&$ent)
{
    $se = entGetStoreEngine($ent);
    $fn = "entCount_$se";
    return $fn($ent);
}

// ******************************************************
// Delete object
// ******************************************************

function entDeleteObj($ent,$objid,&$error)
{
    if (entEventHandlerExists("ondeleted",$ent))
    {
        entLoadObj($ent,$objid,$obj,$error);
        entExecuteEventHandlerOnDeleted($ent,$obj,$error);
    }

    $se = entGetStoreEngine($ent);
    $fn = "entDeleteObj_$se";
    return $fn($ent,$objid,$error);
}

function entClear($ent,&$error)
{
    if (entEventHandlerExists("ondeleted",$ent))
    {
        entLoadObjs($ent,$objs,$error);
        foreach($objs as $obj) {
            entExecuteEventHandlerOnDeleted($ent,$obj,$error);
        }
    }

    $se = entGetStoreEngine($ent);
    $fn = "entClear_$se";
    return $fn($ent,$error);
}

// ******************************************************
// Admin
// ******************************************************

function entAdmin(&$ent)
{
    $ret = "";
    if (!entProcessForm($ent,$obj,$error))
    {
        $ret .= $error;
    }

    $ret .= entDisplayFormCard($ent);
    $ret .= entDisplayTableCard($ent);
    return $ret;
}

function entAdminSingleton($ent)
{
    if (!entProcessForm($ent,$obj,$error))
    {
        return displayError("Cannot update object",$error);
    }

    if (!entLoadOrCreateObj($ent,"",$obj,$error))
    {
        return displayError("Cannot display object",$error);
    }

    $cardtitle = $ent["title"];
    $ret = "<div style='max-width:".entGetWidth($ent).";'>";
    $ret .= card($cardtitle);
    $ret .= entDisplayForm($ent,$obj);
    $ret .= cardend();

    $ret .= "</div>";
    return $ret;
}

?>
