<?php
//**********************************************************
// Attr: url
//
// Url
// $n = "url";
// $ent["a"][$n] = attrUrl($n,"Url");
// $ent["a"][$n]["list"] = true;
// $ent["a"][$n]["below"] = "Website url starting with https://";
// $ent["a"][$n]["groupbox"] = $groupbox;
// $ent["a"][$n]["order"] = $order++;
//
//**********************************************************

function attrUrl($name,$label="")
{
	$attr = createAttr("url",$name,$label);
	return $attr;
}

//**************************************************************
// Input
//**************************************************************
function attrUrlInput($ent,$attr,$obj)
{
	//Description
	$entname = $ent["name"];
	$name = $attr["name"];
	$label = $attr["label"];
	$class = array_key_exists("class",$attr) ? $attr["class"] : "form-control";
	$style = array_key_exists("style",$attr) ? $attr["style"] : "";
	$placeholder = array_key_exists("placeholder",$attr) ? $attr["placeholder"] : "https://company.com";
	$inputname = $entname."_".$name;

	//Object value
	$value = htmlspecialchars(attrLoadValue($ent,$attr,$obj));
	
	//Display label
    $inputlabel = attrDisplayLabel($attr);

	//Display input
	$input = "<input type='url' name='$inputname' placeholder='$placeholder' class='$class' style='$style' value='$value'>";
	$inputline = attrDisplayInput($input);

	//Below label
	$below = attrDisplayBelow($attr);

	return $inputlabel.$inputline.$below;
}

//**************************************************************
// Display
//**************************************************************
function attrUrlDisplayValue($ent,$attr,$obj)
{
	$aname = $attr["name"];
	$ret = $obj[$aname];
	return "<a href='$ret'>$ret</a>";
}


?>
