<?php
//**********************************************************
// Attr: up down
//**********************************************************

function attrUpdown($name,$label="Order")
{
	$attr = createAttr("updown",$name,$label);
	$attr["list"] = true;
	$attr["form"] = true;
	return $attr;
}

function attrUpdownAddedToEnt(&$ent)
{
	if (!array_key_exists("onlisted",$ent) || !array_key_exists("processUpdownRequest",$ent["onlisted"]))
	{
		$ent["onlisted"][] = "processUpdownRequest";
	}
}

function attrUpdownDisplayValue($ent,$attr,$obj)
{
	global $owpn;
	$objid = $obj["id"];

	$extra = getLinkExt($ent,"updown");

	$urlup="index.php?owpn=$owpn&updown=up&objid=$objid".$extra;
	$buttonup = "<a href='$urlup'><div class='btn btn-secondary'>&#9650;</div></a>";

	$urldown="index.php?owpn=$owpn&updown=down&objid=$objid".$extra;
	$buttondown = "<a href='$urldown'><div class='btn btn-secondary'>&#9660;</div></a>";

	$ret = "<div class='col ps-2'>";
	$ret .= "<table><tr><td>$buttonup</td><td>$buttondown</td></tr></table>";
	$ret .= "</div>";
	return $ret;
}

function attrUpdownInput($ent,$attr,$obj)
{
	//Description
	$name = $attr["name"];
	$entname = $ent["name"];
	$value = attrLoadValue($ent,$attr,$obj);
	$value = htmlspecialchars($value);
	$inputname = $entname."_".$name;

	//Display input
	$ret = "<input type='hidden' name='$inputname' value='$value'>";

	return $ret;
}

function processUpdownRequest(&$ent,$obj,&$error)
{
	global $updown,$objid;
	loadReqParams("updown","objid");
	if ($objid!=$obj["id"]) return true;
	if ($updown=='up')
	{
		objmoveup($ent,$objid);
	}

	if ($updown=='down')
	{
		objmovedown($ent,$objid);
	}

	return true;
}

function objmoveup(&$ent,$objid)
{
	entLoadObjs($ent,$items,$error);
	$prevobj=null;
	foreach($items as $item)
	{
		$itemid = $item["id"];
		if ($itemid==$objid)
		{
			if ($prevobj==null) return;
			$prevorder = $prevobj["order"]+0;
			$origorder = $item["order"]+0;
			$item["order"] = $prevorder;
			$prevobj["order"] = $origorder;
			if ($item["order"] == $prevobj["order"]) $item["order"]=$item["order"]-1;
			entSaveObj($ent,$item,$error);
			entSaveObj($ent,$prevobj,$error);
			$ent["reload"] = true;
			return;
		}
		$prevobj = $item;
	}
}

function objmovedown(&$ent,&$objid)
{
	entLoadObjs($ent,$items,$error);
	$prevobj=null;
	foreach($items as $item)
	{
		if ($prevobj==null)
		{
			$prevobj = $item;
			continue;
		}

		$itemid = $prevobj["id"];
		if ($itemid==$objid)
		{
			if ($prevobj==null) return;
			$origorder = $item["order"]+0;
			$item["order"] = $prevobj["order"]+0;
			$prevobj["order"] = $origorder;
			if ($item["order"] == $prevobj["order"]) $item["order"]=$item["order"]+1;
			entSaveObj($ent,$item,$error);
			entSaveObj($ent,$prevobj,$error);
			$ent["reload"] = true;
			return;
		}
		$prevobj = $item;
	}
}
?>