<?php
function findCreditCardType($cardnumber)
{
    if (isempty($cardnumber)) return "unknown";

    if (preg_match('/^(?!1800)1\d{0,14}/', $cardnumber)) {
        return "uatp";
    }

    if (preg_match('/^3[47]\d{0,13}/', $cardnumber)) {
        return "americanexpress";
    }

    if (preg_match('/^(?:6011|65\d{0,2}|64[4-9]\d?)\d{0,12}/', $cardnumber)) {
        return "discover";
    }

    if (preg_match('/^3(?:0([0-5]|9)|[689]\d?)\d{0,11}/', $cardnumber)) {
        return "diners";
    }

    if (preg_match('/^(5[1-5]\d{0,2}|22[2-9]\d{0,1}|2[3-7]\d{0,2})\d{0,12}/', $cardnumber)) {
        return "mastercard";
    }

    if (preg_match('/^(5019|4175|4571)\d{0,12}/', $cardnumber)) {
        return "dankort";
    }

    if (preg_match('/^63[7-9]\d{0,13}/', $cardnumber)) {
        return "instapayment";
    }

    if (preg_match('/^(?:2131|1800)\d{0,11}/', $cardnumber)) {
        return "jcb15";
    }

    if (preg_match('/^(?:35\d{0,2})\d{0,12}/', $cardnumber)) {
        return "jcb";
    }

    if (preg_match('/^(?:5[0678]\d{0,2}|6304|67\d{0,2})\d{0,12}/', $cardnumber)) {
        return "maestro";
    }

    if (preg_match('/^220[0-4]\d{0,12}/', $cardnumber)) {
        return "mir";
    }

    if (preg_match('/^4\d{0,15}/', $cardnumber)) {
        return "visa";
    }

    if (preg_match('/^(62|81)\d{0,14}/', $cardnumber)) {
        return "unionpay";
    }

    if (preg_match('/^389[0-9]\d{0,11}/', $cardnumber)) {
        return "carteblanche";
    }

    if (preg_match('/^(6541|6556)[0-9]\d{0,12}/', $cardnumber)) {
        return "bcglobal";
    }

    if (preg_match('/^9[0-9]\d{0,15}/', $cardnumber)) {
        return "koreanlocal";
    }

    if (preg_match('/^(6304|6706|6709|6771)[0-9]\d{12,15}/', $cardnumber)) {
        return "lasercard";
    }

    if (preg_match('/^(6334|6767)[0-9]\d{0,12}|(6334|6767)[0-9]\d{0,14}|(6334|6767)[0-9]\d{0,15}/', $cardnumber)) {
        return "solo";
    }

    if (preg_match('/^(4903|4905|4911|4936|6333|6759)[0-9]\d{0,12}|(4903|4905|4911|4936|6333|6759)[0-9]\d{0,14}|(4903|4905|4911|4936|6333|6759)[0-9]\d{0,15}|564182[0-9]\d{0,10}|564182[0-9]\d{0,12}|564182[0-9]\d{0,13}|633110[0-9]\d{0,10}|633110[0-9]\d{0,12}|633110[0-9]\d{0,13}/', $cardnumber)) {
        return "switchcard";
    }

    return "unknown";
}
?>