<?php
//**********************************************************
// Attr: textArea
//
// $submit["name"] = "mytext";
// $submit["label"] = "Enter the text";
// $submit["class"] = "";
//**********************************************************

function attrTextarea($name,$label="")
{
	return createAttr("textarea",$name,$label);
}

function attrTextareaInput($ent,$attr,$obj)
{
	//Description
	$entname = $ent["name"];
	$name = $attr["name"];
	$class = array_key_exists("class",$attr) ? $attr["class"] : "";
	$style = array_key_exists("style",$attr) ? $attr["style"] : "";
	$placeholder = array_key_exists("placeholder",$attr) ? $attr["placeholder"] : "";
	$inputname = $entname."_".$name;

	//Default values
	if (isEmpty($name)) $name="mytext";
	if (isEmpty($class)) $class="form-control";

	//Object value
	$value = array_key_exists("value",$attr)? htmlspecialchars($attr["value"]) : "";
	if ($obj!=null && isset($obj[$name])) $value = htmlspecialchars($obj[$name]);

	//Display label
    $inputlabel = attrDisplayLabel($attr);

	//Display input
	$placeholder = htmlspecialchars($placeholder);
	$input = "<textarea name='$inputname' class='$class' style='$style' placeholder='$placeholder'>$value</textarea>";
	$inputline = attrDisplayInput($input);

	//Below label
	$below = attrDisplayBelow($attr);

	return $inputlabel.$inputline.$below;
}

?>
