<?php
//**********************************************************
// Attr: textArea
// Docs: 
// https://www.tiny.cloud/docs/tinymce/6/php-projects/
// https://www.tiny.cloud/docs/tinymce/6/basic-setup/
//
// $submit["name"] = "mytext";
// $submit["label"] = "Enter the text";
// $submit["class"] = "";
//**********************************************************

function attrRichtext($name,$label="")
{
	return createAttr("richtext",$name,$label);
}

$richtextjsincluded = false;
function attrRichtextInput($ent,$attr,$obj)
{
	global $richtextjsincluded;

	//Description
	$entname = $ent["name"];
	$name = $attr["name"];
	$label = $attr["label"];
	$toolbarhide =  array_key_exists("toolbarhide",$attr) ?  $attr["toolbarhide"] : false;
	$height =  array_key_exists("height",$attr) ?  $attr["height"] : "300";
	$class = array_key_exists("class",$attr) ? $attr["class"] : "";
	$placeholder = array_key_exists("placeholder",$attr) ? $attr["placeholder"] : "";
	$inputname = $entname."_".$name;

	//Default values
	if (isEmpty($name)) $name="mytext";
	if (isEmpty($class)) $class="form-control";

	//Object value
	$value = array_key_exists("value",$attr)? htmlspecialchars($attr["value"]) : "";
	if ($obj!=null && $obj[$name]) $value = htmlspecialchars($obj[$name]);

	//Display label
    $inputlabel = attrDisplayLabel($attr);

	//Megj:
	//További toolbar opció az image
	//Display input
	$richtextjs = "";
	if (!$richtextjsincluded)
	{
		$richtextjsincluded = true;
		$richtextjs = '<script src="/ozekiservices/system/attachments/1/falcon/vendors/tinymce/tinymce.js" referrerpolicy="origin"></script>';
	}

	$toolbarhidejs = "";
	if ($toolbarhide)
	{
		$toolbarhidejs = <<<TOOLBARJSEND
		setup: function(theEditor) {
			theEditor.on('focus',function() {
				$(this.container.children[0]).find("div.tox-editor-header").show();
				$(this.container).find("div.tox-statusbar").show();
				//theEditor.focus();
			});
			theEditor.on('blur',function() {
				$(this.container.children[0]).find("div.tox-editor-header").hide();
				$(this.container).find("div.tox-statusbar").hide();
			});
			theEditor.on('init',function() {
				$(this.contentAreaContainer.parentElement.parentElement).find("div.tox-editor-header").hide();
				$(this.contentAreaContainer.parentElement.parentElement.parentElement).find("div.tox-statusbar").hide();
			});
		}
TOOLBARJSEND;
	}

	$input= <<<INPUTEND
	<div style="border-radius: 0.25rem; border: 1px solid #2c7be6;">
      <textarea id="tiny$inputname" name='$inputname' class='$class'>$value</textarea>
    </div>
    $richtextjs
    <script>
      tinymce.init({
        selector: '#tiny$inputname',
		plugins: 'wordcount link image lists emoticons charmap table hr',
  		toolbar1: 'undo redo | removeformat | forecolor backcolor  | superscript subscript strikethrough | link emoticons charmap hr| wordcount',
		toolbar2: 'h1 h2 h3  | bold italic underline | bullist numlist | outdent indent | alignleft aligncenter alignright alignjustify',
		contextmenu: "cut copy paste",
		statusbar: true,
		branding: false,
		elementpath: false,
		wordcount: true,
		menubar: false,
		resize: 'both',
		content_style: "body { margin: 5px; margin-top:-10px; padding:0px; font-size:1rem; }", 
		height: $height,
		$toolbarhidejs
      });
    </script>

INPUTEND;

	$inputline = attrDisplayInput($input);

	//Below label
	$below = attrDisplayBelow($attr);

	return $inputlabel.$inputline.$below;
}

?>