<?php
//**********************************************************
// Attr: text
//
// $submit["name"] = "mytext";
// $submit["label"] = "Enter the text";
// $submit["class"] = "";
//**********************************************************

function attrLabel($name,$label="")
{
	return createAttr("label",$name,$label);
}

function attrLabelInput($ent,$attr,$obj)
{
	//Description
	$entname = $ent["name"];
	$name = $attr["name"];
	$label = $attr["label"];
	$class = $attr["class"] ?? "";
	$placeholder = $attr["placeholder"] ?? "";
	$inputname = $entname."_".$name;

	//Default values
	if (isEmpty($name)) $name="mytext";
	if (isEmpty($class)) $class="form-control";

	//Object value
	$value = htmlspecialchars($attr["value"] ?? "");
	if ($obj!=null && isset($obj[$name])) $value = htmlspecialchars($obj[$name]);
	
	//Display label
    $inputlabel = attrDisplayLabel($attr);

	//Display input
	$input = "<input type='hidden' name='$inputname' value='$value'>";
	$input .= "<div class='form-control' style='background-color:#cecece'>$value</div>";
	$inputline = attrDisplayInput($input);

	//Below label
	$below = attrDisplayBelow($attr);

	return $inputlabel.$inputline.$below;
}

?>