<?php
//**********************************************************
// Attr: text
//**********************************************************

function attrInt($name,$label="")
{
	return createAttr("int",$name,$label);
}

function attrIntInput($ent,$attr,$obj)
{
	//Description
	$entname = $ent["name"];
	$name = $attr["name"];
	$label = $attr["label"];
	$class = array_key_exists("class",$attr) ? $attr["class"] : "";
	$style = array_key_exists("style",$attr) ? $attr["style"] : "max-width:60px";
	$placeholder = array_key_exists("placeholder",$attr) ? $attr["placeholder"] : "";
	$inputname = $entname."_".$name;

	//Default values
	if (isEmpty($name)) $name="mytext";
	if (isEmpty($class)) $class="form-control";

	//Object value
	$value = htmlspecialchars(attrLoadValue($ent,$attr,$obj));
	
	//Display label
    $inputlabel = attrDisplayLabel($attr);

	//Display input
	$input = "<input type='number' name='$inputname' placeholder='$placeholder' class='$class' style='$style' value='$value'>";
	$inputline = attrDisplayInput($input);

	//Below label
	$below = attrDisplayBelow($attr);

	return $inputlabel.$inputline.$below;
}


function attrIntDisplayValue($ent,$attr,$obj)
{
	$aname = $attr["name"];
	$value = $obj[$aname];
	$ret = number_format($value,0,"."," ");
	return $ret;
}

function attrIntProcessInput($ent,$attr,&$obj,&$error)
{
	$error = "";
	$entname = $ent["name"];
	$attrname = $attr["name"];

	$inputname = $entname."_".$attrname;
	global $$inputname;
	loadReqParams($inputname);
	$obj[$attrname] = intval($$inputname);
	return true;
}

?>
