<?php
//**********************************************************
// File input attribute for form
//
// $attrDesc:
// "name" : profileimage
// "accept" : image/jpeg,image/png,image/webp
// "accept" : .xlsx,.xls,image/*,.doc, .docx,.ppt, .pptx,.txt,.pdf
//**********************************************************
function attrFile(&$ent,$name,$label="",$accept=array())
{
	if (count($accept)==0)
	{
		$accept[] = "application/msword";
		$accept[] = "application/vnd.ms-excel";
		$accept[] = "application/vnd.ms-powerpoint";
		$accept[] = "text/plain";
		$accept[] = "application/pdf";
		$accept[] = "application/zip";
		$accept[] = "image/png";
		$accept[] = "image/webp";
		$accept[] = "image/jpeg";
		$accept[] = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
		$accept[] = "application/vnd.openxmlformats-officedocument.presentationml.slideshow";
		$accept[] = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
		$accept[] = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
		$accept[] = ".csv";
	}

	$a = createAttr("file",$name,$label);
	$a["accept"] = $accept;
	$a["sizelimit"] = 5*1024*1024; //5 Mb

	$ent["enctype"] = "multipart/form-data";
	return $a;
}


function attrFileInput($ent,$attr,$obj)
{
	//Description
	$entname = $ent["name"];
	$name = $attr["name"];
	$class = array_key_exists("class",$attr) ? $attr["class"] : "";
	$accept = implode(", ",$attr["accept"]);
	$inputname = $entname."_".$name;

	//Default values
	if (isEmpty($name)) $name="file";
	if (isEmpty($class)) $class="mt-2";

	//Object value
	$value=null;
	if (is_array($obj) && array_key_exists($name,$obj) && !isEmpty($obj[$name]))
	{
		$dir = entGetObjDir($ent,$obj["id"]);
		$file = ozpathcombine($dir,$obj[$name]);
		if (file_exists($file)) $value=$obj[$name];
	} 

	//Display label
    $inputlabel = attrDisplayLabel($attr);

	//Display input
	$input = "";
	if ($value!=null) 
	{
		$currentvalue = htmlspecialchars($value);
		$currentvaluename ="$inputname"."_value"; 
		$delcheckboxname = "$inputname"."_del";
		$nicefilename = str_replace("_aes","",$value);
		$input  = "<div style='float:left'>";
		$input .= "<input type='hidden' name='$currentvaluename' value='$currentvalue' >";
		$input .= "<input type='checkbox' name='$delcheckboxname' class='form-check-input'> Delete ";
		$input .= "<span style='color:blue'>$nicefilename</span> (".ozfilesize($file).") ";
		$input .= "</div><br>";
	}
	$input .= "<input type='file' name='$inputname' accept='$accept' class='$class'>";
	$inputline = attrDisplayInput($input);

	//Below label
	$below = attrDisplayBelow($attr);

	return $inputlabel.$inputline.$below;
}

function attrFileProcessInput($ent,$attr,&$obj,&$error)
{
	$inputname = $ent["name"]."_".$attr["name"];
	$currentvaluename = $inputname."_value"; 
	$delcheckboxname = $inputname."_del";

	global $$currentvaluename,$$delcheckboxname,$siteid;
	loadReqParams($currentvaluename,$delcheckboxname);

	$dir = entGetObjDir($ent,$obj["id"]);
	if (isEmpty($dir))
	{
		$error = "File upload failed. The upload directory is not specified.";
        return false;
	}

	$currentfilename = $$currentvaluename;
	$currentfile = "$dir/".$currentfilename;
	if (!isEmpty($currentfilename) && $$delcheckboxname=="on" && file_exists($currentfile))
	{
		unlink($currentfile);
	}

	$aeskey = array_key_exists("aeskey",$ent) ? $ent["aeskey"] : null;
	//Note: biztonsági okokból ügyfél által feltöltött fájl csak encrypted formában lehet a gépen
	//ez megakadályozza a gép feltörését feltöltött fájlokkal, valamint védi az ügyfél adatát
	if (isEmpty($aeskey)) $aeskey = $siteid;

	$entname = $ent["name"];
	$attrname = $attr["name"];
	$inputname = $entname."_".$attrname;
	$file=$_FILES[$inputname];

	if ($file["size"]==0)
	{
		$obj[$attrname] = $$currentvaluename;
		return true;
	}

	if (!isEmpty($currentfilename) && file_exists($currentfile))
	{
		unlink($currentfile);
	}

	if($file["size"]>$attr["sizelimit"]) 
    {
		$sizelimit = ozkbsize($attr["sizelimit"]); 
        $error = "File upload failed. File size exceeds the upload limit ($sizelimit).";
        return false;
    }

	$filetype=$file["type"];
	$filename=$file["name"];

	if(!ozmkdir($dir,$error))
    {
        $error = "File upload failed. Upload directory creation failed. $error";
        return false;
    }

	$ftmpname = pathinfo($filename, PATHINFO_FILENAME)."_tmp".ozfiletypetoextension($filetype);
	$ftemp =ozpathcombine($dir,$ftmpname);

    if(!move_uploaded_file($file["tmp_name"],$ftemp))
    {
        $error = "File upload failed. Could not find uploaded temp file.";
        return false;
    }

	$fname = pathinfo($filename, PATHINFO_FILENAME).ozfiletypetoextension($filetype);
	if (array_key_exists("appenddate",$attr) && $attr["appenddate"]) $fname .= "_".date("ymdhis");
	$fname .= "_aes";

	$f =ozpathcombine($dir,$fname);
    if (!encryptFileAES($aeskey, $ftemp, $f, $error)) 
    {
        $error = "File upload failed. Could not encrypt uploaded file.";
        return false;
    }

	unlink($ftemp);
	
	$obj[$attrname] = $fname;
	return true;
}

function attrFileDisplayValue($ent,$attr,$obj)
{
	global $mypassword,$datadir,$owpname,$siteid;

	$aname = $attr["name"];
	$filename = $obj[$aname];
	if (isEmpty($filename)) return "";

	$removechars = 4; //"_aes" postfix
	if (array_key_exists("appenddate",$attr) && $attr["appenddate"]) $removechars += 13;
	
	$nicename =  substr($filename,0,strlen($filename)-$removechars);
	$p =ozpathcombine($ent["dir"],$obj["id"],$filename);
	$filesize = ozfilesize(ozpathcombine($datadir,$p));
	$path = urlencode($p);
	
	$filekey = (array_key_exists("aeskeey",$ent)) ? $ent["aeskey"] : "";
	if (isEmpty($filekey)) $filekey = $siteid;
	$urlkey = convertToAesKey($mypassword);
	$keyencrypted = urlencode(encryptTextAES($urlkey, $filekey));
	$downloadurl = "index.php?srv=system&api=filedownload&nicename=$nicename&path=$path&k=$keyencrypted";
	$icon = "<i class='fa fa-paperclip' aria-hidden='true'></i>";
	$downloadlink = "$icon&nbsp;<a href='$downloadurl'>$nicename ($filesize)</a>";
	
	$ret = $downloadlink;
	return $ret;
}


//**********************************************************
// Example:
// $imgUrl = attrFileImgUrl($ent,$obj,"myimg")
//**********************************************************

function attrFileImgUrl($ent,$obj,$attrname)
{
	global $siteid;
	$picture = $obj[$attrname];
    $aeskey = $ent["aeskey"];
	$dir = $ent["dir"]."/".$obj["id"]."/".$picture;
    $urlkey = convertToAesKey($siteid);
    $k = encryptTextAES($urlkey, $aeskey); //ez megy az url-be
    $url = "index.php?srv=system&api=imagedownload&path=".urlencode($dir)."&k=$k";
	return $url;
}

//**********************************************************
// Example:
// $imgUrl = attrFileImgUrl($ent,$obj,"myimg")
//**********************************************************

function attrFileImgPath($ent,$obj,$attrname)
{
	global $siteid;
	$picture = $obj[$attrname];
    $aeskey = $ent["aeskey"];
	$dir = $ent["dir"]."/".$obj["id"]."/".$picture;
	return $dir;
}

?>
