<?php
//**********************************************************
// Attr: date
//**********************************************************

function attrDate($name,$label="")
{
	return createAttr("date",$name,$label);
}

function attrDateInput($ent,$attr,$obj)
{
	//Description
	$entname = $ent["name"];
	$name = $attr["name"];
	$label = $attr["label"];
	$class = array_key_exists("class",$attr) ? $attr["class"] : "form-control";
	$style = array_key_exists("style",$attr) ? $attr["style"] : "max-width:300px";
	$placeholder = array_key_exists("placeholder",$attr) ? $attr["placeholder"] : "YYYY-MM-DD";
	$inputname = $entname."_".$name;

	//Default values
	if (isEmpty($name)) $name="mydate";

	//Object value
	$value = htmlspecialchars(attrLoadValue($ent,$attr,$obj));
	
	//Display label
    $inputlabel = attrDisplayLabel($attr);

	//Display input
	$input = "<input class='$class datetimepicker' id='datepicker$inputname' type='text' name='$inputname' placeholder='$placeholder' style='$style' value='$value' data-options='{\"enableTime\":false,\"dateFormat\":\"Y-m-d\",\"disableMobile\":true}'/>";
	$inputline = attrDisplayInput($input);

	//Below label
	$below = attrDisplayBelow($attr);

	return $inputlabel.$inputline.$below;
}

//**********************************************************
// Other support functions
//**********************************************************

function comboMonth($inputname,$selecteditem)
{
	$months = [];

	for ($monthoffset = 0;$monthoffset<24;$monthoffset++)
    {
        $date = mysqldate();
        $date = date('Y-m', strtotime("-".$monthoffset." months", strtotime($date)));
        $months[] = $date;
    }

	$combo = "<SELECT name='$inputname' class='me-2'>";
	foreach ($months as $item)
	{
		$selected = ($item==$selecteditem)? "SELECTED":"";
		$combo.="<OPTION value='$item' $selected>$item</OPTION>";
	}
	$combo .= "</SELECT>";

	return $combo;
}


?>