<?php
//**********************************************************
// Attr: combobox
//**********************************************************

function attrComboboxStatic($name,$label="")
{
	return createAttr("ComboboxStatic",$name,$label);
}

function attrComboboxStaticInput($ent,$attr,$obj)
{
	//Description
	$entname = $ent["name"];
	$name = $attr["name"];
	$label = $attr["label"];
	$ent = array_key_exists("ent",$attr) ? $attr["ent"] : null;
	$class = array_key_exists("class",$attr) ? $attr["class"] : "";
	$style = array_key_exists("style",$attr) ? $attr["style"] : "";
	$nullable = array_key_exists("nullable",$attr) ? $attr["nullable"] : true;
	$inputname = $entname."_".$name;

	//Default values
	if (isEmpty($name)) $name="mycombobox";
	if (isEmpty($class)) $class="form-select";

	//Object value
	$value = array_key_exists("value",$attr)? htmlspecialchars($attr["value"]) : "";
	if ($obj!=null && $obj[$name]) $value = htmlspecialchars($obj[$name]);

	//Display label
    	$inputlabel = attrDisplayLabel($attr);

	//Load options
	$options = "";

	foreach($attr["options"] as $option)
	{
		$optionvalue = htmlspecialchars($option);
		$selected = ($value==$optionvalue) ? "selected" : "";
		$optiontitle = $option;
		$options .= "<option value='$optionvalue' $selected>$optiontitle</option>\r\n";
	}

	//Display input
	$input = "<select name='$inputname' class='$class' style='$style'>";
	if ($nullable) {
		$input .= "<option value=''>- Please select -</option>";
	}
	$input .= $options;
	$input .= "</select>";
	$inputline = attrDisplayInput($input);

	//Below label
	$below = attrDisplayBelow($attr);

	return $inputlabel.$inputline.$below;
}

?>
