<?php
//**********************************************************
// Attr: combobox
//**********************************************************

function attrCombobox($name,$label="")
{
	return createAttr("combobox",$name,$label);
}

function attrComboboxGetOptionTitle($aent,$attr,$aobj)
{
	$namefunc = array_key_exists("namefunc",$aent) ? $aent["namefunc"] : "";
	$nameattr = array_key_exists("nameattr",$aent) ? $aent["nameattr"] : "name";
	$optiontitle = (!isEmpty($namefunc)) ? $namefunc($aent,$attr,$aobj) : $aobj[$nameattr];
	return $optiontitle;
}

function attrComboboxInput($ent,$attr,$obj)
{
	//Description
	$entname = $ent["name"];
	$name = $attr["name"];
	$label = $attr["label"];
	$aent = $attr["ent"];
	$class = array_key_exists("class",$attr) ? $attr["class"] : "";
	$style = array_key_exists("style",$attr) ? $attr["style"] : "";
	$nullable = array_key_exists("nullable",$attr) ? $attr["nullable"] : true;
	$inputname = $entname."_".$name;

	//Default values
	if (isEmpty($name)) $name="mycombobox";
	if (isEmpty($class)) $class="form-select";

	//Object value
	$value = array_key_exists("value",$attr)? htmlspecialchars($attr["value"]) : "";
	if ($obj!=null && $obj[$name]) $value = htmlspecialchars($obj[$name]);
	$selectedvalue = $value;

	//Remembered value
	if (isEmpty($selectedvalue) && attrComboboxLoadRememberd($ent,$attr,$lastvalue))
	{
		$selectedvalue = $lastvalue;
	}

	//Display label
    $inputlabel = attrDisplayLabel($attr);

	//Load options
	$options = "";
	if (entLoadObjs($aent,$aobjs,$error))
	{
		$valueattr = array_key_exists("valueattr",$aent) ? $aent["valueattr"] : "id";
		foreach($aobjs as $aobj)
		{
			$optionvalue = htmlspecialchars($aobj[$valueattr]);
			$selected = ($selectedvalue==$optionvalue) ? "selected" : "";
			$optiontitle = attrComboboxGetOptionTitle($aent,$attr,$aobj);
			$options .= "<option value='$optionvalue' $selected>$optiontitle</option>\r\n";
		}
	}

	//Display input
	$input = "<select name='$inputname' class='$class' style='$style'>";
	if ($nullable) {
		$input .= "<option value=''>- Please select -</option>";
	}
	$input .= $options;
	$input .= "</select>";
	$inputline = attrDisplayInput($input);

	//Below label
	$below = attrDisplayBelow($attr);

	return $inputlabel.$inputline.$below;
}

function attrComboboxProcessInput($ent,$attr,&$obj,&$error)
{
	$error = "";
	$entname = $ent["name"];
	$attrname = $attr["name"];

	$inputname = $entname."_".$attrname;
	global $$inputname;
	loadReqParams($inputname);
	$obj[$attrname] = $$inputname;

	attrComboboxSaveRememberd($ent,$attr,$$inputname);

	return true;
} 

function attrComboboxDisplayValue($ent,$attr,$obj)
{
	$aname = $attr["name"];
	$aobjid = $obj[$aname];

	$aent = $attr["ent"];
	if (!entLoadObj($aent,$aobjid,$aobj,$error))
	{
		return $aobjid;
	}

	return attrComboboxGetOptionTitle($aent,$attr,$aobj);
}


function attrComboboxLoadRememberd($ent,$attr,&$lastvalue)
{
	if (!array_key_exists("remember",$attr)) return false;
	if ($attr["remember"]==false) return false;

	$formaction = "formaction_".$ent["name"];
	if (!array_key_exists($formaction,$_REQUEST)) return false;
	if ($_REQUEST[$formaction] != "new") return false;

	global $regdir,$myuserid;
	$dir = "$regdir/$myuserid/forms/combobox";
	if (!ozmkdir($dir,$error)) return false;
	$combofile = $ent["name"]."_".$attr["name"].".txt";
	$f = "$dir/$combofile";
	if (!file_exists($f)) return false;
	if (!ozreadfile($f,$lastvalue,$error)) return false;
	return true;
}

function attrComboboxSaveRememberd($ent,$attr,$currentvalue)
{

	if (!array_key_exists("remember",$attr)) return false;
	if ($attr["remember"]==false) return false;
	global $regdir,$myuserid;
	$dir = "$regdir/$myuserid/forms/combobox";
	if (!ozmkdir($dir,$error)) return false;
	$combofile = $ent["name"]."_".$attr["name"].".txt";
	$f = "$dir/$combofile";
	if (!ozsavefile($f,$currentvalue,$error)) return false;
	return true;
}


?>