<?php
//**********************************************************
// Attr: checkbox
//
// ["name"] = "mytext";
// ["label"] = "Enter the text";
// ["class"] = "";
// ["class"] = "truestring/falsestring" | "on/off" | "true/false" | "1/0" 
//**********************************************************

function attrCheckbox($name,$label="",$text="",$mode="on/off")
{
	$ret = createAttr("checkbox",$name,$label);
	if (isEmpty($text)) $text = $label;
	$ret["text"] =$text;
	$ret["mode"] = $mode;
	return $ret;
}

function attrCheckboxInput($ent,$attr,$obj)
{
	//Description
	$entname = $ent["name"];
	$name = $attr["name"];
	$label = $attr["label"];
	$text = $attr["text"];
	$class = array_key_exists("class",$attr) ? $attr["class"] : "";
	$inputname = $entname."_".$name;

	//Default values
	if (isEmpty($name)) $name="mycheckbox";
	if (isEmpty($class)) $class="form-check-input";

	//Object value
	$value = array_key_exists("value",$attr)? htmlspecialchars($attr["value"]) : "";
	if ($obj!=null && $obj[$name]) $value = htmlspecialchars($obj[$name]);

	//Display label
    $inputlabel = attrDisplayLabel($attr);

	//Display input
	$checked = ($value=="on" || $value=="true" || $value==true || $value==1 || $value=="1") ? "checked" : "";
	if ($value=="false") $checked = "";
	$input = "<div><input type='checkbox' name='$inputname' class='$class ozcheckbox' style='border: 1px solid #2c7be6;' $checked> $text</div>";
	$inputline = attrDisplayInput($input);

	return $inputlabel.$inputline;
}


function attrCheckboxProcessInput($ent,$attr,&$obj,&$error)
{
	$entname = $ent["name"];
	$attrname = $attr["name"];
	$inputname = $entname."_".$attrname;
	
	global $$inputname;
	loadReqParams($inputname);

	if ($attr["mode"]=="on/off")
	{
		if($$inputname=="on")
			$obj[$attrname] = "on";
		else 
			$obj[$attrname] = "off";
	} 

	if ($attr["mode"]=="truestring/falsestring")
	{
		if($$inputname=="true" || $$inputname=="on")
			$obj[$attrname] = "true";
		else 
			$obj[$attrname] = "false";
	} 

	if ($attr["mode"]=="true/false")
	{
		if($$inputname==true || $$inputname=="on")
			$obj[$attrname] = true;
		else 
			$obj[$attrname] = false;
	} 

	if ($attr["mode"]=="1/0")
	{
		if($$inputname==1 || $$inputname=="on")
			$obj[$attrname] = 1;
		else 
			$obj[$attrname] = 0;
	} 


	return true;
}

function attrCheckboxDisplayValue($ent,$attr,$obj)
{
	global $checkbox_on_icon, $checkbox_off_icon;
	$aname = $attr["name"];
	$value = $obj[$aname];
	$checkboxon = (isset($checkbox_on_icon)) ? $checkbox_on_icon : "&#x2611;";
	$checkboxoff = (isset($checkbox_off_icon)) ? $checkbox_off_icon : "";
	$ret = ($value=="on") ? $checkboxon : $checkboxoff;
	return $ret;
}


?>
