<?php
// ******************************************************
// Entity Type Selector
// ******************************************************
function addCreatorAttr(&$ent,$typeCreatorFunc)
{
    $ent["a"]["typecreator"] = attrHidden("typecreator","Type creator");
    $ent["a"]["typecreator"]["value"] = $typeCreatorFunc;
}

function entTypeSelected(&$ent,$obj)
{
    $typeCreatorFunc = null;
    if (!array_key_exists("typeselector",$ent)) return true;
    if (isEmpty($ent["typeselector"])) return true;

    //Select type from object
    if ($obj!=null && array_key_exists("typecreator",$obj))
    {
        $typeCreatorFunc = $obj["typecreator"];
        $ent = ozExecFunc($typeCreatorFunc);
        addCreatorAttr($ent,$typeCreatorFunc);
        return true;
    }

    //Select type from request parameter
    $buttonname = $ent["name"]."_selectedtype";
    global $$buttonname;
    loadReqParams($buttonname);
    $typeCreatorFunc = $$buttonname;
    if (!isEmpty($typeCreatorFunc))
    {
        $ent = ozExecFunc($typeCreatorFunc);
        addCreatorAttr($ent,$typeCreatorFunc);
        return true;
    }

    return false;
}

function entDisplayTypeSelector($ent)
{
    $formheader = entDisplayFormHeader($ent,null);
    $formaction = entDisplayFormAction($ent,"new");
    $typeselector = entDisplayTypeOptions($ent);
    $formfooter = entDisplayFormFooter();
    return $formheader.$formaction.$typeselector.$formfooter;
}

function entDisplayTypeOptions($ent)
{
    $typeselectorname = $ent["typeselector"];
    $typeselector = $typeselectorname($ent);
    $types = $typeselector["t"];

    $buttonname = $ent["name"]."_selectedtype";
    $ret = $typeselector["descriptionformtop"];
    $ret .= "<HR>";

    foreach($types as $type)
    {
        $caption = $type["caption"];
        $creator = $type["create"];
        $typeoption = <<<TYPEOPTIONEND
        <div class='row mt-2'>
            <div class='col'>
            <button class='btn btn-primary' name='$buttonname' value='$creator'>$caption</button>
            </div>
        </div>
TYPEOPTIONEND;
        $ret .= "$typeoption\r\n";
    }

    return $ret;
}

?>