<?php
//**********************************************************
// Attr
//**********************************************************
$attrOrder = 0;

function createAttr($type,$name,$label)
{
	global $attrOrder;

	$ret = array();
	$ret["type"] = $type;
	$ret["name"] = "$name";
	$ret["label"] = "$label";
	$attrOrder++;
	$ret["order"] = $attrOrder;
	return $ret;
}

function attrDisplayLabel($attr)
{
	$label = $attr["label"];
	$description = array_key_exists("description",$attr) ? $attr["description"] : "";

	if (isEmpty($label) && isEmpty($description)) return "";
	if (!isEmpty($description)) $description = "<div class='mb-1'>$description</div>";
	if (!isEmpty($label)) $label = "<div style='font-weight:bold'>$label:</div>";

	//Display label
	$inputlabel =<<<INPUTLABEL
	<div class="row">   
        <div class="col text-start">
		$description
		$label
		</div>
    </div> 
INPUTLABEL;

	return $inputlabel;
}

function attrDisplayBelow($attr)
{
	$label = array_key_exists("below",$attr) ? $attr["below"] : "";

	if (isEmpty($label)) return "";
	if (!isEmpty($label)) $label = "<div class='fst-italic fw-light' style='margin-top:-8px'>$label</div>";

	//Display label
	$belowlabel =<<<BELOWLABEL
	<div class="row">   
        <div class="col mb-2 text-start">
		$label
		</div>
    </div> 
BELOWLABEL;

	return $belowlabel;
}

function attrDisplayInput($input)
{
	if (isEmpty($input)) return "";

	$input =<<<INPUTTEXT
	<div class="row">
		<div class="col mb-2 text-start">
			$input
		</div>
	</div>
INPUTTEXT;

	return $input;
}

function attrLoadValue($ent,$attr,$obj)
{
	$value = "";
	$name = $attr["name"];
	
	if (isset($obj[$name]) && $obj[$name]!="") 
	{
		$value = $obj[$name];
		if ($value!="") return $value;
	} 

	if (isEmpty($value))
	{
		$value = array_key_exists("value",$attr) ? $attr["value"] : "";
	}

	if (isEmpty($value) && array_key_exists("default",$attr))
	{
		$value = $attr["default"]($ent);
	}
	
	return $value;
}

function attrCreateValue($ent,$attr,&$obj,&$error)
{
	$error = "";
	$entname = $ent["name"];
	$attrname = $attr["name"];
	$obj[$attrname] = $attr["defaultvalue"] ?? "";
	return true;
}

function attrDisplayValue($ent,$attr,$obj)
{
	$aname = $attr["name"];
	if (!isset($obj[$aname])) return "";
	$ret = $obj[$aname];
	return $ret;
}

function attrProcessInput($ent,$attr,&$obj,&$error)
{
	$error = "";
	$entname = $ent["name"];
	$attrname = $attr["name"];

	$inputname = $entname."_".$attrname;
	global $$inputname;
	loadReqParams($inputname);
	$obj[$attrname] = $$inputname ?? "";
	return true;
}

?>
