<?php

//*************************************************
// Events / User created
//*************************************************
$onUserCreated = [];

function SubscribeOnUserCreated($functionname)
{
	global $onUserCreated;
	if (!is_array($onUserCreated)) return;
	if (in_array($functionname,$onUserCreated)) return;
	$onUserCreated[] = $functionname;
}

function CallOnUserCreated($userid,$userdetails,&$error,$rsakey,$aeskey)
{
	global $onUserCreated;
	if (!is_array($onUserCreated)) return true;
	foreach($onUserCreated as $funcname)
	{
		if (!function_exists($funcname)) continue;
		if (!$funcname($userid,$userdetails,$error,$rsakey,$aeskey))
		{
			$error = "Error while executing create hook $funcname. $error";
			return false;
		}
	}
	return true;
}

//*************************************************
// Events / User updated
//*************************************************
$onUserUpdated = [];

function SubscribeOnUserUpdated($functionname)
{
	global $onUserUpdated;
	if (in_array($functionname,$onUserUpdated)) return;
	$onUserUpdated[] = $functionname;
}

function CallOnUserUpdated($userid,$userdetails,&$error,$aeskey=null)
{
	global $onUserUpdated;
	foreach($onUserUpdated as $funcname)
	{
		if (!function_exists($funcname)) continue;
		if (!$funcname($userid,$userdetails,$error,$aeskey))
		{
			$error = "Error while executing update hook $funcname. $error";
			return false;
		}
	}
	return true;
}

//*************************************************
// Events / User updated
//*************************************************
$onHardwareDescriptionProvided = [];

function SubscribeOnHardwareDescriptionProvided($functionname)
{
	global $onHardwareDescriptionProvided;
	if (in_array($functionname,$onHardwareDescriptionProvided)) return;
	$onHardwareDescriptionProvided[] = $functionname;
}

function CallOnHardwareDescriptionProvided($fromip,$userid,$stationid,$hardwareid,$desc,&$error)
{
	global $onHardwareDescriptionProvided;
	foreach($onHardwareDescriptionProvided as $funcname)
	{
		if (!function_exists($funcname)) continue;
		if (!$funcname($fromip,$userid,$stationid,$hardwareid,$desc,$error))
		{
			$error = "Error while executing hardware registration hook $funcname. $error";
			return false;
		}
	}
	return true;
}



?>