<?php

//*******************************************************
// Service specific RSA keys
//*******************************************************
function generateRsaKeypairForSrv(&$error) : bool
{
	global $myprivatekey,$servicename,$regdir,$myuserid;

	if (!generateRsaKeypairForService($myuserid,$servicename, $error))
		return false;

	$servicedir = "$regdir/$myuserid/$servicename";
	$privatekeyfile = $servicedir."/privatekey.txt";
	$pemencrypted = file_get_contents($privatekeyfile);
	if (!decryptTextRSAAES($myprivatekey, $pemencrypted,$pemdecrypted,$error)) 
		return false;
	importRsaPrivateKeyFromPEM($pemdecrypted, "", $myservicePrivateKey, $myservicePublicKey,$error);

	$varname = "privatekey_$servicename";
	global $$varname;
	$$varname = $myservicePrivateKey;

	$varname = "publickey_$servicename";
	global $$varname;
	$$varname = $myservicePublicKey;
	return true;
}

function loadRsaPrivateKeyForSrv($userid,$userprivatekey,$serviceid,&$servicePrivateKey,&$servicePublicKey,&$error) : bool
{
	global $regdir, $myuserid, $myprivatekey,$mypublickey;

	if ($myuserid==$serviceid)
	{
		 $servicePrivateKey = $myprivatekey;
		 $servicePublicKey = $mypublickey;
		 $error = null;
		 return true;
	}

	//Itt a shared mappában kell kutakodni
	$servicedir = "$regdir/$userid/$serviceid";
	$privatekeyfile = $servicedir."/privatekey.txt";
	$pemencrypted = file_get_contents($privatekeyfile);
	if (!decryptTextRSAAES($userprivatekey, $pemencrypted,$pemdecrypted,$error)) 
	{
		$error = "Cannot load private key for service. Cannot decrypt pem. $error";
		return false;
	}
	if (!importRsaPrivateKeyFromPEM($pemdecrypted, "", $servicePrivateKey, $servicePublicKey,$error))
	{
		$error = "Cannot load private key for service. Cannot import pem. $error";
		return false;
	}
	return true;
}

function keypairForServiceExists($userid,$service) : bool
{
	global $regdir;
	$servicedir = "$regdir/$userid/$service";
	$publickeyfile = $servicedir."/publickey.txt";
	return file_exists($publickeyfile);
}

function loadRsaPublicKeyForSrv($userid,$service,&$publicKey,&$error) : bool
{
	global $mydetails,$myprivatekey,$servicename,$regdir;
	$publickeyfile = "$regdir/$userid/$service/publickey.txt";

	if (!file_exists($publickeyfile))
	{
		if (!generateRsaKeypairForService($userid,$service,$error))
		{
			$error = "RSA service key generation failed. $error";
			return false;
		}
	}

	$pem = file_get_contents($publickeyfile);
	if (!importRsaPublicKeyFromPEM($pem, $publicKey,$error))
	{
		$error = "RSA service key import failed. $error";
		return false;
	}

	return true;
}

function generateRsaKeypairForService($userid,$service, &$error) : bool
{
	global $datadir,$myuserid;
	$servicedir = $datadir."/registrations/".$userid."/".$service;
	$privatekeyfile = $servicedir."/privatekey.txt";
	$publickeyfile = $servicedir."/publickey.txt";

	if (file_exists($privatekeyfile)) return true;

	if (!userexists($userid))
	{
		$error = "Could not generate key pair for service. User does not exist";
		return false;
	}

	if (!is_dir($servicedir) && !mkdir($servicedir, 0777, true))
	{
		$error = "Could not generate key pair for service. Could not generate RSA key pair. Could not create service directory; ".$servicedir."; ".error_get_last()["message"];
		return false;
	}

	if ($myuserid==$userid)
	{
		global $mypublickey;
		$ownerPublicKey = $mypublickey;
	} 
	else
	{
		$ownerPublicKeyFile = $datadir."/registrations/".$userid."/publickey.txt";
		$ownerPublicKeyPem = file_get_contents($ownerPublicKeyFile);
		if (!importRsaPublicKeyFromPEM($ownerPublicKeyPem, $ownerPublicKey,$error))
			return false;
	}

	if (!is_resource($ownerPublicKey) && !is_object($ownerPublicKey))
	{
		$error = "Could not generate key pair for service. Could not load RSA public key of $userid";
		return false;
	}

	if (!generateRsaKeypair($privateKey,$publicKey,$error))
	{
		$error = "Could not generate key pair for service. RSA key generation failed. $error";
		return false;
	}

	$pemprivate = exportRsaPrivateKeyToPEM($privateKey);
	$encryptedpemprivate = encryptTextRSAAES($ownerPublicKey, $pemprivate);
	file_put_contents($privatekeyfile,$encryptedpemprivate);

	$pempublic = exportRsaPublicKeyToPEM($publicKey);
	file_put_contents($publickeyfile,$pempublic);

	//save for admin
	$shareddir = $datadir."/registrations/".$userid."/sharedto";
	if (!ozmkdir($shareddir, $error))
	{
		return false;
	}
	global $adminpublickey,$adminuserid;
	$adminkeyfile = $shareddir."/".$adminuserid."_".$service."_rsa.txt";
	$encryptedpemprivate = encryptTextRSAAES($adminpublickey, $pemprivate);
	file_put_contents($adminkeyfile,$encryptedpemprivate);

	return true;
}

//*******************************************************
// Service specific AES keys
//*******************************************************
function loadOrGenerateMyAesKeyForSrv($servicename,$serviceid,&$aesdecrypted, &$error) : bool
{
	global $myuserid, $myprivatekey,$dirprefix;
	if (!generateAesKeyForUserService($servicename,$serviceid,$myuserid,$aeskey, $errorm))
	{
		$error = "AES key generation for user service failed. $errorm";
		return false;
	}

	if (!loadMyEncryptedAesKeyForService($servicename,$serviceid,$aesdecrypted,$errorm))
	{
		$error = "AES key import for user service failed. $errorm";
		return false;
	}
	return true;
}

function loadMyEncryptedAesKeyForService($servicename,$serviceid, &$aesdecrypted,&$error) : bool
{
	global $regdir,$myuserid,$myprivatekey;

	if (!isEmpty($serviceid)) $serviceid = ".".$serviceid;

	$aeskeyfile = "$regdir/".$myuserid."/".$servicename."/aeskey$serviceid.txt";
	if (!file_exists($aeskeyfile))
	{
		$error = "AES key file does not exist";
		return false;	
	}
	$aesencrypted = file_get_contents($aeskeyfile);

	if (!decryptTextRSA($myprivatekey,$aesencrypted,$aesdecrypted,$error))
	{
		$error = "AES key file decryption error. $error";
		return false;
	}

	return true;
}



function generateAesKeyForUserService($servicename,$serviceid,$userid,&$aeskey,&$error) : bool
{
	global $datadir,$mydetails,$myuserid,$myemail;
	
	$servicedir = $datadir."/registrations/".$userid."/".$servicename;
	if (!isEmpty($serviceid)) $serviceid = ".".$serviceid;
	$aeskeyfile = $servicedir."/aeskey".$serviceid.".txt";
	$currentuser = $myemail;
	$aeskey = null;

	if (file_exists($aeskeyfile)) return true;

	if (!ozmkdir($servicedir,$error))
	{
		return false;
	}

	if ($myuserid==$userid)
	{
		global $mypublickey;
		$ownerPublicKey = $mypublickey;
	} 
	else
	{
		$ownerPublicKeyFile = $datadir."/registrations/".$userid."/publickey.txt";
		$ownerPublicKeyPem = file_get_contents($ownerPublicKeyFile);
		if (!importRsaPublicKeyFromPEM($ownerPublicKeyPem, $ownerPublicKey,$error))
			return false;
	}

	if (!is_resource($ownerPublicKey) && !is_object($ownerPublicKey))
	{
		$error = "Could not load RSA public key of user $userid";
		return false;
	}

	$aeskey = generateAesKey();
	$encryptedkey = encryptTextRSA($ownerPublicKey, $aeskey);
	file_put_contents($aeskeyfile,$encryptedkey);

	//save for admin
	$shareddir = $datadir."/registrations/".$userid."/sharedto";
	if (!ozmkdir($shareddir,$error))
	{
		$error = "Could not share AES key with admin";
		return false;
	}
	global $adminpublickey,$adminuserid;
	$adminkeyfile = $shareddir."/".$adminuserid."_".$servicename.$serviceid."_aes.txt";
	$encryptedkey = encryptTextRSAAES($adminpublickey, $aeskey);
	file_put_contents($adminkeyfile,$encryptedkey);

	return true;
}

// servicename = "Ticket"
// serviceid = md5("supportserviceof@ozeki.hu")
// userid = md5("customer@ozeki.hu");
// sharedtouserid = md5("ozekisupportagent@ozeki.hu");
function isAesServiceKeySharedTo($servicename,$serviceid,$userid,$sharedtouserid)
{
	global $regdir;
	if (!isEmpty($serviceid)) $serviceid = ".".$serviceid;
	$aessharedtofriendfile = "$regdir/$userid/sharedto/".$sharedtouserid."_".$servicename.$serviceid."_aes.txt";
	if (file_exists($aessharedtofriendfile))
	{
		return true;
	}
	return false;
}

// servicename = "Ticket"
// serviceid = md5("ticketserviceof@ozeki.hu")
// userid = md5("customer@ozeki.hu");
// sharedtouserid = md5("ozekisupportagent@ozeki.hu");
function shareAesServiceKeyTo($servicename,$serviceid,$userid,$aeskey,$sharedtouserid,&$error)
{
	global $regdir,$myuserid,$mypublickey,$myprivatekey,$mydetails;

	if (!isEmpty($serviceid)) $serviceid = ".".$serviceid;

	//Load my secret AES key genereated for service
	$aessharedtofriendfile = "$regdir/$userid/sharedto/".$sharedtouserid."_".$servicename.$serviceid."_aes.txt";
	if (file_exists($aessharedtofriendfile))
	{
		$error = "Service key sharing error. Key already shared.";
		return false;
	}

	//Load public key of shared to user 
	$friendpublickeypemfile = "$regdir/$sharedtouserid/publickey.txt";
	if (!file_exists($friendpublickeypemfile))
	{
		$error = "Service key sharing error. Could not find public key of $email";
		return false;
	}
	
	$friendpublickeypem = file_get_contents($friendpublickeypemfile);
	if (!importRsaPublicKeyFromPEM($friendpublickeypem, $friendpublickey,$error))
	{
		return false;
	}
	
	//Share key to service
	$aessharedtofriend = encryptTextRSA($friendpublickey,$aeskey);
	if (!file_put_contents($aessharedtofriendfile,$aessharedtofriend))
	{
		$errorPassword = "Service key sharing error. Cannot write shared key file for $email. ".error_get_last()["message"];
		return false;
	}

	return true;
}

function unshareAesServiceKeyTo($servicename,$serviceid,$userid,$sharedtouserid,&$error)
{
	global $regdir;
	if (!isEmpty($serviceid)) $serviceid = ".".$serviceid;
	$aessharedtofriendfile = "$regdir/$userid/sharedto/".$sharedtouserid."_".$servicename.$serviceid."_aes.txt";
	if (!file_exists($aessharedtofriendfile))
	{
		$error = "Service key unsharing error. Key was not shared.";
		return false;
	}

	unlink($aessharedtofriendfile);
	return true;
}

function loadAesServiceKey($service,&$aeskey,&$error)
{
	global $mydetails;
	$myuserid = md5($mydetails['email']);
	return loadAesServiceKeyOf($myuserid,$service,$aeskey,$error);
}

function loadAesServiceKeyOfUser($userhash,$userprivatekey,$friendhash,$service,&$aeskey,&$error)
{
	global $datadir,$userdir,$debug;
	$frienddir = $datadir."/registrations/$friendhash";
	
	if (!is_dir($frienddir))
	{
		$error = "Friend not found $email";
		return false;
	}

	if ($userhash==$friendhash)
	{
		$keysharedtome = $frienddir."/$service/aeskey.txt";
	} else {
		$keysharedtome = $frienddir."/sharedto/".$userhash."_".$service."_aes.txt";
	}

	if (!file_exists($keysharedtome))
	{
		$error = "$friendhash has not shared his/hers service key to me for service $service.";
		if ($debug) $error.=" File not found: ".$keysharedtome."<BR>";
		return false;
	}
	$keydata = file_get_contents($keysharedtome);

	if (!decryptTextRSA($userprivatekey,$keydata,$aeskey,$error))
	{
		$error = "$friendhash did not encrypt his/hers key properly, the key is not readable";
		return false;
	}
	return true;
}

function loadAesServiceKeyOf($friendhash,$service,&$aeskey,&$error)
{
	global $myuserid,$myprivatekey;
	return loadAesServiceKeyOfUser($myuserid,$myprivatekey,$friendhash,$service,$aeskey,$error);
}

//***********************************************************
// Szolgáltatás specifikus AES key betöltés
// 1.) A user a saját kulcsát be tudja tölteni
// 2.) A serviceid user a user kulcsát be tudja tölteni, mert a user megosztotta vele, amiokr feliratkozott
// 3.) A többi user akkor tudja betölteni, ha ismerik a serviceid private kulcsát, mert a service admin megosztotta velük
//     ők ezen private kulcs ismeretében be tudják tölteni a service számára megosztott aes kulcsot
//***********************************************************

function loadAesKeyForService($servicename,$userid,$serviceid,&$aeskey,&$error)
{
	//$debug = true;
	global $regdir,$myuserid,$myprivatekey,$debug;
	if (!isEmpty($serviceid)) $dotserviceid = ".".$serviceid;

	//The user wants to load his own service key
	if ($userid==$myuserid)
	{
		$file = "$regdir/$userid/$servicename/aeskey".$dotserviceid.".txt";
		if (!ozloadencryptedrsa($myprivatekey,$file,$aeskey,$errorm))
		{
			$error = "Could not load AES key for service. Owner decryption error.";
			if ($debug) { $error.= " ".$errorm;}
        	return false;
		}

		return true;
	}

	//The current user is the service (The AES key is shared to the service)
	if ($myuserid==$serviceid)
	{
		$file = "$regdir/$userid/sharedto/".$serviceid."_".$servicename.$dotserviceid."_aes.txt";

		if (!ozloadencryptedrsa($myprivatekey,$file,$aeskey,$errorm))
		{
			$error = "Could not load AES key for service. Owner decryption error.";
			if ($debug) { $error.= " ".$errorm;}
        	return false;
		}

		return true;
	}

	//Other users can load the AES key if the key was explicitly shared to them
	$sharedtouserid = $myuserid;
	$file = "$regdir/$userid/sharedto/".$myuserid."_".$servicename.$dotserviceid."_aes.txt";
	if (file_exists($file))
	{
		if (!ozloadencryptedrsa($myprivatekey,$file,$aeskey,$errorm))
		{
			$error = "Could not load AES key for service. Owner decryption error.";
			if ($debug) { $error.= " ".$errorm;}
        	return false;
		}

		return true;
	}

	//Other users can also load the AES key if they know the private key of the service
	$file = "$regdir/$serviceid/sharedto/".$myuserid."_rsa.txt";
	//$error = "Find:".$file;return false;
	if (file_exists($file))
	{
		//$error = "Exists:".$file;return false;
		if (!ozloadencryptedrsaaes($myprivatekey,$file,$pem,$errorm))
		{
			$error = "Could not load AES key for service. Owner decryption error.";
			if ($debug) { $error.= " ".$errorm;}
        	return false;
		}

		if (!importRsaPrivateKeyFromPEM($pem, null, $privateKey, $publicKey, $errorm))
		{
			$error = "Could not load AES key for service. Rsa private key decryption error.";
			if ($debug) { $error.= " ".$errorm;}
        	return false;
		}

		$file = "$regdir/$userid/sharedto/".$serviceid."_".$servicename.$dotserviceid."_aes.txt";
		if (!ozloadencryptedrsa($privateKey,$file,$aeskey,$errorm))
		{
			$error = "Could not load AES key for service. Owner service decryption error.";
			if ($debug) { $error.= " ".$errorm;}
        	return false;
		}

		return true;
	}

	$error = "Could not load AES key for service. The user does not have access to this data.";
	return false;

}


?>
