<?php

//*************************************************
// RSA public key
//*************************************************

function ozloadrsapublickeyof($userid,&$publicKey,&$error) : bool
{
	global $regdir;
	$publickeyfile = "$regdir/$userid/publickey.txt";
	if (!file_exists($publickeyfile))
	{
		$error = "Public key not found for $userid";
		return false;
	}

	$pem = file_get_contents($publickeyfile);
	if (!importRsaPublicKeyFromPEM($pem, $publicKey,$error))
		return false;

	return true;
}

//*************************************************
// RSA private key
//*************************************************

function ozloadrsaprivatekeyof($userid,&$rsaprivatekey,&$error)
{
	//$debug = true;
	global $myuserid,$myprivatekey,$regdir;
	if ($myuserid==$userid) 
	{
		$rsaprivatekey = $myprivatekey;
		return true;
	}

	$file = "$regdir/$userid/sharedto/".$myuserid."_rsa.txt";
	if (!file_exists($file))
	{
		$error = "The user did not share his key to me.";
		return false;
	}

	if (!ozloadencryptedrsaaes($myprivatekey,$file,$pem,$errorm))
	{
		$error = "Could not load RSA key of user. Decryption error.";
		if (isDebug()) { $error.= " ".$errorm;}
		return false;
	}

	if (!importRsaPrivateKeyFromPEM($pem, null, $rsaprivatekey, $publicKey, $errorm))
	{
		$error = "Could not load RSA private key of user. Key import error.";
		if (isDebug()) { $error.= " ".$errorm;}
		return false;
	}

	return true;
}


function ozloadrsaprivatekeyofuser($userid,$password,&$privateKey,&$error) : bool
{
	global $regdir,$myprivatekey,$myuserid;
	$passwordHash=sha512($password);
	if($userid==$myuserid)
	{
		$privateKey=$myprivatekey;
		return true;
	}
	$privatekeyfile = "$regdir/$userid/privatekey_".$passwordHash.".txt";
	if (!file_exists($privatekeyfile))
	{
		$error = "Cannot load private key. Private key not found.";
		return false;
	}

	$pem = file_get_contents($privatekeyfile);
	if (!importRsaPrivateKeyFromPEM($pem, $password, $privateKey, $publicKey, $error))
	{
		$error = "Cannot load private key. Import failed. $error";
		return false;
	}
	return true;
}

function ozloadrsaprivatekeyofsharedto($userid,$sharedto,&$rsaprivatekey,&$error)
{
	global $regdir;

	if (!ozloadrsaprivatekeyof($sharedto,$rsaprivatekeyofsharedto,$error))
	{
		$error = "Cannot load shared private key.";
		return false;
	}

	$file = "$regdir/$userid/sharedto/".$sharedto."_rsa.txt";
	if (!file_exists($file))
	{
		$name = GetName($userid);
		$myname = GetName($sharedto);
		$error = "User $name ($userid) did not share his key to $myname ($sharedto).";
		return false;
	}

	if (!ozloadencryptedrsaaes($rsaprivatekeyofsharedto,$file,$pem,$errorm))
	{
		var_dump($rsaprivatekeyofsharedto);
		var_dump($file);
		var_dump($pem);

		$error = "Could not load RSA key of user. Decryption error.";
		return false;
	}

	if (!importRsaPrivateKeyFromPEM($pem, null, $rsaprivatekey, $publicKey, $errorm))
	{
		$error = "Could not load RSA private key of user. Key import error.";
		return false;
	}

	return true;
}

//*************************************************
// RSA private key sharing
//*************************************************

function ozsharemyrsaprivatekeyto($userid,&$error)
{
	global $myuserid,$myprivatekey,$regdir;
	$sharedrsakeyfile = "$regdir/$myuserid/sharedto/$userid"."_rsa.txt";
	if (file_exists($sharedrsakeyfile)) 
	{
		$error = "";
		return true;
	}

	$pem  = exportRsaPrivateKeyToPEM($myprivatekey);
    if (!ozencryptrsaaesto($userid,$pem,$pemencrypted,$errorm))
    {
        $error="Cannot share private key. Cannot encrypt key to $userid.";
        if (isDebug()) { $error.= " ".$errorm;}
		return false;
    }
    
    if (!ozsavefile($sharedrsakeyfile,$pemencrypted,$errorm))
    {
        $error="Cannot share private. Cannot save shared key for user.";
        if (isDebug()) { $error.= " ".$errorm;}
		return false;
    }

	return true;
}

function ozsharersaprivatekeyto($userid,$userpass,$sharedtoid,&$error)
{
	global $regdir;
	//$debug = true;

	$sharedrsakeyfile = "$regdir/$userid/sharedto/$sharedtoid"."_rsa.txt";
	if (file_exists($sharedrsakeyfile)) return true;

	if (!ozloadrsaprivatekeyofuser($userid,$userpass,$privateKey,$error))
	{
		$error = "Cannot share RSA private key. Cannot load key of user. $error";
		return false;
	}

	$pem  = exportRsaPrivateKeyToPEM($privateKey);

    if (!ozencryptrsaaesto($sharedtoid,$pem,$pemencrypted,$errorm))
    {
        $error="Cannot share RSA private key. Cannot encrypt key of $userid to $sharedtoid.";
        if (isDebug()) { $error.= " ".$errorm;}
		return false;
    }
    
    if (!ozsavefile($sharedrsakeyfile,$pemencrypted,$errorm))
    {
        $error="Cannot share private. Cannot save shared key for user.";
        if (isDebug()) { $error.= " ".$errorm;}
		return false;
    }

	return true;
}

//*************************************************
// RSA encryption
//*************************************************
function ozencryptrsaaesto($userid,$text,&$encrypted,&$error)
{
	global $datadir;
	$encrypted = null;

	if (!ismd5($userid))
	{
		$error = "Invalid user id";
		return false;
	}

	$frienddir = $datadir."/registrations/$userid";
	if (!is_dir($frienddir))
	{
		$error = "Friend not found $userid";
		return false;
	}

	$friendpublickeypemfile = $frienddir."/publickey.txt";
	if (!file_exists($friendpublickeypemfile))
	{
		$error = "Could not find public key of user";
		return false;
	}

	$friendpublickeypem = file_get_contents($friendpublickeypemfile);
	if (!importRsaPublicKeyFromPEM($friendpublickeypem, $friendpublickey,$error))
		return false;

	$encrypted = encryptTextRSAAES($friendpublickey,$text);
	return true;
}

?>