<?php
function ozencryptshared($content)
{
	global $myaesshared;
	return encryptTextAES($myaesshared,$content);
}

function ozdecryptshared($encrypted)
{
	global $myaesshared;
	return decryptTextAES($myaesshared,$encrypted);
}

function ozencryptprivate($content)
{
	global $myaesprivate;
	return encryptTextAES($myaesprivate,$content);
}

function ozdecryptprivate($encrypted)
{
	global $myaesprivate;
	return decryptTextAES($myaesprivate,$encrypted);
}

function ozsaveshared($filename,$content,&$error)
{
	global $myaesshared;
	return ozsaveencrypted($myaesshared,$filename,$content,$error);
}

function ozloadshared($filename,&$content,&$error)
{
	global $myaesshared;
	return ozloadencrypted($myaesshared,$filename,$content,$error);
}

function ozsaveprivate($filename,$content,&$error)
{
	global $myaesprivate;
	return ozsaveencrypted($myaesprivate,$filename,$content,$error);
}

function ozloadprivate($filename,&$content,&$error)
{
	global $myaesprivate;
	return ozloadencrypted($myaesprivate,$filename,$content,$error);
}

//**********************************************************
// Share AES shared key
//**********************************************************

function ozsharemykeyto($sharedtouserid,&$error)
{
	global $myuserid,$myaesshared;
	return ozshareaeskeyto($myaesshared,$myuserid,$sharedtouserid,$error);
}

function ozshareaeskeyto($aeskey,$aeskeyowner,$sharedtouserid,&$error)
{
	global $regdir;
	
	$aessharedtofriendfile = "$regdir/$aeskeyowner/sharedto/".$sharedtouserid."_aesshared.txt";
	if (file_exists($aessharedtofriendfile))
	{
		//$error = "Key already shared to $sharedtouserid";
		$error = "";
		return true;
	}

	$friendpublickeypemfile = "$regdir/$sharedtouserid/publickey.txt";
	if (!file_exists($friendpublickeypemfile))
	{
		$error = "Could not find public key of $sharedtouserid";
		return false;
	}
	
	$friendpublickeypem = file_get_contents($friendpublickeypemfile);
	if (!importRsaPublicKeyFromPEM($friendpublickeypem, $friendpublickey,$error))
	{
		return false;
	}
	
	$aessharedtofriend = encryptTextRSA($friendpublickey,$aeskey);
	if (!ozsavefile($aessharedtofriendfile,$aessharedtofriend,$error))
	{
		$error = "Cannot write shared key file for $sharedtouserid. $error";
		return false;
	}

	return true;
}

//**********************************************************
// Load AES shared key
//**********************************************************
function ozloadaessharedkeyof($userid,&$aeskey,&$error)
{
	global $myuserid,$myprivatekey;
	return ozloadaessharedkeyofuser($userid,$myuserid,$myprivatekey,$aeskey,$error);
}

function ozloadaessharedkeyofuser($userid,$sharedtoid,$sharedtoprivatekey,&$aeskey,&$error)
{
	global $regdir,$debug,$myaesshared;
	if ($userid==$sharedtoid)
	{
		$keyshared = "$regdir/$userid/aesshared.txt";
	} else {
		$keyshared = "$regdir/$userid/sharedto/".$sharedtoid."_aesshared.txt";
	}
	if (!file_exists($keyshared))
	{
		$error = "$userid not shared his/hers key.";
		if ($debug) $error.=" File not found: $keyshared";
		return false;
	}
	$keydata = file_get_contents($keyshared);

	if (!decryptTextRSA($sharedtoprivatekey,$keydata,$aeskey,$error))
	{
		$error = "$userid did not encrypt his/hers key properly. $error";
		return false;
	}

	return true;
}

function ozloadaeskeyof($userid,$rsaprivatekeyofuserid,&$aeskey,&$error)
{
	global $regdir;
	$aeskeyfile = "$regdir/$userid/aesshared.txt";
	if (!ozreadfile($aeskeyfile,$aeskeyencrypted,$error)) 
	{
		$error = "Cannot load user aes key. Shared aes file could not be loaded.";
		return false;
	}
	if (!decryptTextRSA($rsaprivatekeyofuserid,$aeskeyencrypted,$aeskey,$error))
	{
		$error = "Cannot load user aes key. Shared aes file could not be decrypted.";
		return false;
	}
	return true;
}

//**********************************************************
// Load AES private key
//**********************************************************
function ozloadaesprivatekeyof($userid,&$aeskey,&$error)
{
	global $myuserid,$myprivatekey;
	return ozloadaesprivatekeyofuser($userid,$myuserid,$myprivatekey,$aeskey,$error);
}

function ozloadaesprivatekeyofuser($userid,$sharedtoid,$sharedtoprivatekey,&$aeskey,&$error)
{
	global $regdir,$debug,$myaesshared;
	if ($userid==$sharedtoid)
	{
		$keyshared = "$regdir/$userid/aesprivate.txt";
	} else {
		$keyshared = "$regdir/$userid/sharedto/".$sharedtoid."_aesprivate.txt";
	}
	if (!file_exists($keyshared))
	{
		$error = "$userid not shared his/hers key.";
		if ($debug) $error.=" File not found: $keyshared";
		return false;
	}
	$keydata = file_get_contents($keyshared);

	if (!decryptTextRSA($sharedtoprivatekey,$keydata,$aeskey,$error))
	{
		$error = "$userid did not encrypt his/hers key properly. $error";
		return false;
	}

	return true;
}

function ozloadaesprivatekeyofusingrsa($userid,$rsaprivatekeyofuserid,&$aeskey,&$error)
{
	global $regdir;
	$aeskeyfile = "$regdir/$userid/aesprivate.txt";
	if (!ozreadfile($aeskeyfile,$aeskeyencrypted,$error)) 
	{
		$error = "Cannot load user aes key. Shared aes file could not be loaded.";
		return false;
	}
	if (!decryptTextRSA($rsaprivatekeyofuserid,$aeskeyencrypted,$aeskey,$error))
	{
		$error = "Cannot load user aes key. Shared aes file could not be decrypted.";
		return false;
	}
	return true;
}


//**********************************************************
// Save encrypted json
//**********************************************************

function ozsavesharedjson($userid,$filename,$data,&$error)
{
	if (!ozloadrsaprivatekeyof($userid,$rsaprivatekeyofuser,$error))
	{
		$error = "Could not save shared json file. Cannot load private key. $error";
		return false;
	}

	if (!ozloadaeskeyof($userid,$rsaprivatekeyofuser,$aeskeyofuser,$error))
	{
		$error = "Could not save shared json file. Cannot load aes key. $error";
		return false;
	}

	if (!ozsaveencryptedjson($aeskeyofuser,$filename,$data,$error))
	{
		$error = "Could not save shared json file. Cannot save file. $error";
		return false;
	}
	
	return true;
}

function ozloadsharedjson($userid,$filename,&$data,&$error)
{
	if (!ozloadrsaprivatekeyof($userid,$rsaprivatekeyofuser,$error))
	{
		$error = "Could not load shared json file. Cannot load private key. $error";
		return false;
	}

	if (!ozloadaeskeyof($userid,$rsaprivatekeyofuser,$aeskeyofuser,$error))
	{
		$error = "Could not load shared json file. Cannot load aes key. $error";
		return false;
	}

	if (!ozloadencryptedjson($aeskeyofuser,$filename,$data,$error))
	{
		$error = "Could not load shared json file. Cannot load file. $error";
		return false;
	}

	return true;
}
?>
